import java.io.*;

public class Extension
{
    String cr = "\r\n"; // Make sure we always add these two

    void addToFile( String filename, String text )
    {
        StringBuffer newData = new StringBuffer( getFile( filename ) );
        newData.append( text );
        saveFile( filename, newData.toString() );
    }

    boolean lineInFile( String filename, String start )
    {
        String data = getFile( filename );
        int inx;

        for ( inx = 0; inx < numberOfLines( data ); inx++ )
        {
            if ( start.trim().equals( getLine( data, inx ).trim() ) )
            {
                return true;
            }
        }

        return false;
    }


    boolean inFile( String filename, String start )
    {
        String data = getFile( filename );
        int inx;

        for ( inx = 0; inx < numberOfLines( data ); inx++ )
        {
            if ( getLine( data, inx ).trim().startsWith( start.trim() ) )
            {
                return true;
            }
        }

        return false;
    }

    boolean removeFrom( String filename, String start )
    {
        StringBuffer newData = new StringBuffer();
        String data = getFile( filename );
        String lData;
        boolean retval = false;
        int iny;

        for ( iny = 0; iny < numberOfLines( data ); iny++ )
        {
            lData = getLine( data, iny );

            if ( lData.startsWith( start ) )
            {
                retval = true;
            }
            else
            {
                newData.append( lData+"\n" );
            }
        }

        if ( retval )
        {
            saveFile( filename, newData.toString() );
        }

        return retval;
    }

    String getLine( String lines, int num )
    {
        int inx;
        int currentLine = 0;
        StringBuffer thisLine = new StringBuffer();

        for ( inx = 0; inx < lines.length(); inx++ )
        {
            if ( lines.charAt( inx ) == '\n' )
            {
                currentLine++;
            }
            else if ( lines.charAt( inx ) == '\r' )
            {
                // Do nothing
            }
            else if ( currentLine == num )
            {
                thisLine.append( lines.charAt( inx ) );
            }
        }

        return thisLine.toString();
    }

    int numberOfLines( String lines )
    {
        int currentLines = 0;
        int inx;

        if ( lines.length() > 0 )
        {
            currentLines++;
        }

        for ( inx = 0; inx < lines.length(); inx++ )
        {
            if ( lines.charAt( inx ) == '\n' )
            {
                currentLines++;
            }
        }

        return currentLines;
    }

    String argument( String thisLine )
    {
        int iny = 0;
        int maxArg = 255;
        StringBuffer retVal = new StringBuffer();

        while ( ( iny < thisLine.length() ) &&
                ( iny < maxArg ) &&
                ( thisLine.charAt( iny ) != ' ' ) )
        {
            iny++;
        }

        while ( ( iny < thisLine.length() ) &&
                ( iny < maxArg ) &&
                ( thisLine.charAt(iny) == ' ' ) )
        {
            iny++;
        }

        while ( ( iny < thisLine.length() ) &&
                ( iny < maxArg ) )
        {
            retVal.append( thisLine.charAt( iny ) );
            iny++;
        }

        return retVal.toString();
    }

    synchronized String getFile( File fileName )
    {
        String text;
        StringBuffer message = new StringBuffer();
        BufferedReader win;

        try
        {
            win = new BufferedReader(new FileReader( fileName ) );

            while ( win.ready() )
            {
                text = win.readLine();
                message.append( text+"\n" );
            }

            win.close();
        }
        catch ( Exception e ) /** File not found **/
        {
        }

        return message.toString();
    }

    synchronized String getFile( String fileName )
    {
        String text;
        StringBuffer message = new StringBuffer();
        BufferedReader win;

        try
        {
            win = new BufferedReader(new FileReader( fileName ) );

            while ( win.ready() )
            {
                text = win.readLine();
                message.append( text+"\n" );
            }

            win.close();
        }
        catch ( Exception e ) /** File not found **/
        {
        }

        return message.toString();
    }

    synchronized void saveFile( String fileName, String text )
    {
        FileWriter win;

        try
        {
            win = new FileWriter( fileName );
            win.write( text, 0, text.length() );
            win.close();
        }
        catch ( Exception e ) /** error **/
        {
        }
    }


    public Extension()
    {
    }

    public void execute( dixie  log, String thisDomain, String to,
                         String from, String letter, String data )
    {
    }
}


