import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.zip.*;

/**
 Forwards mail separately via a thread.
 **/

public class Forwarder implements Runnable
{
    private dixie  log;
    private String to;
    private String from;
    private String smtpServer;
    private String body;
    private String posRes;
    private String forwarderThread = "Fwd";
    private Letters letters;
    private boolean returnToSender = false;
    private String thisServer = "127.1.1.1";
    private String cr = "\r\n";

    public void run()
    {
        String oldResult;
        smtp mail;
        boolean sending = true;
        boolean loggingRetries = false; // Do not log a retry
        String result = "";

        if ( smtp.subnetUser( to ).equals("dead") )
        {
            log.write( forwarderThread + ": Sent mail to " +
                       to + " to trash" );
            return; // Do not send to the dead user
        }

        while ( sending ) // While attempting a server
        {
            sending = false;

            mail = new smtp( smtp.subnetDomain( to ), smtp.subnetUser( to ), from, body );

            log.write( forwarderThread + ": " +
                       smtp.subnetDomain( to ) + "<subnet>: " +
                       mail.errorResult() );

            if ( mail.result() ) // Forwarded directly OK
            {
                 result = posRes + "(subnet)";
            }
            else if ( mail.errorResult().startsWith( "421" ) ) // Too many connections
            {
                sending = true; // Resend
            }
            else // Try forwarding an internal address
            {
                if ( !smtp.subnetDomain( to ).equals( smtp.domain( to ) ) )
                {
                    mail = new smtp( smtp.domain( to ), to, from, body );
                    log.write( forwarderThread + ": " +
                               smtp.domain( to ) + "<domain>: " +
                               mail.errorResult() );
                }

                if ( mail.result() )
                {
                    result = posRes;
                }
                else if ( mail.errorResult().startsWith( "421" ) ) // Too many connections
                {
                    sending = true; // Resend
                }
                else // External network
                {
                    log.write( forwarderThread + ": Forward external to " +
                               SmtpServer.getOutgoingSmtp() );

                    mail = new smtp( SmtpServer.getOutgoingSmtp(),
                                     to, from, body );

                    if ( mail.result() ) // Forwarded OK
                    {
                        result = posRes + "(gateway)";
                    }
                    else if ( mail.errorResult().startsWith( "421" ) ) // Too many connections
                    {
                        sending = true; // Resend
                    }
                    else if ( returnToSender ) // Return to sender
                    {
                        oldResult = mail.errorResult();

                        new Forwarder( thisServer, from, "nobody@nowhere.net",
                            "X-Mail-Returned: "+oldResult+cr+body,
                            log, "Successfully returned to "+from,
                            letters, false );
                        result = smtpServer + ": " + oldResult +
                                 ": - return to " + from;
                                 
                    }
                    else // Do not return
                    {
                        result = "Failed. (No return tried)";
                    }
                }
            }

            if ( sending ) // Resending
            {
                try
                {
                    Thread.sleep( 5000 ); // Wait 5 sec
                }
                catch ( java.lang.InterruptedException ie )
                {  }

                if ( loggingRetries && ( log != null ) )
                {
                    log.write( forwarderThread + ": resending" );
                }
            }
        }

        log.write( forwarderThread + ": " + result );
    }

    /**
     Main routine.  Pass the gateway server (if on an internal network),
     the to address, the from address, the message body, the main dixie
     object (for logging), a positive response message to write to the
     log, and the letters object.
     **/

    public Forwarder( String xsmtpServer, String xto, String xfrom,
                      String xbody, dixie xlog,
                      String xposRes, Letters xletters,
                      boolean xreturn )
    {
        Thread listener;

        smtpServer     = xsmtpServer;
        to             = xto;
        from           = xfrom;
        body           = xbody;
        log            = xlog;
        posRes         = xposRes;
        letters        = xletters;
        returnToSender = xreturn;

        listener = new Thread( this );
        listener.start();
    }
}


