import java.awt.*;
import java.awt.image.*;


public class ImageComponent extends Canvas implements ImageObserver
{
    Image image    = null;
    Image altImage = null;
    MediaTracker imageTracker;
    private String label;
    private int imageHeight = 0;
    private int imageWidth  = 0;
    private boolean setup    = false;
    private boolean altSetup = false;
    private boolean useAlt   = false;

    public void useAlt( boolean alternate )
    {
        useAlt = alternate;
        repaint();
    }

    public String getLabel()
    {
        return label;
    }

    public void setLabel( String toSet )
    {
        label = toSet;
    }

    public boolean imageUpdate( Image xx, int yy, int x, int y,
       int wide, int high )
    {
        imageHeight = high;
        imageWidth  = wide;
        repaint();

        return false;
    }

    public int getHeight()
    {
        imageSetup();
        return imageHeight;
    }

    public int getWidth()
    {
        imageSetup();
        return imageWidth;
    }

    public void setAltImage( Image i )
    {
        if ( altSetup )
        {
            imageTracker.removeImage( altImage, 1 );
        }

        altImage = i;
        altSetup = true;
        imageTracker.addImage( altImage, 1 );
        imageSetup();
    }

    public void setImage( Image i )
    {
        if ( setup )
        {
            imageTracker.removeImage( image, 0 );
        }

        image = i;
        setup = true;
        imageTracker.addImage( image, 0 );
        imageSetup();
    }

    void imageSetup()
    {
        repaint();
        imageHeight = image.getHeight( this );
        imageWidth  = image.getWidth( this );
    }

    public ImageComponent( Image i )
    {
        // intentionaly set for testing
        imageTracker = new MediaTracker( this );
        setImage( i );
    }

    public void paint( Graphics g )
    {
        setBackground( Color.black ); // Was blue

        if ( useAlt )
        {
            if ( altImage != null )
            {
                g.drawImage( altImage, 0, 0, this );
            }
            else
            {
                setBackground( Color.red ); // Was blue
            }
        }
        else
        {
            g.drawImage( image, 0, 0, this );
        }

        if( imageTracker.checkID( 0, true ) )
        {
            setSize( image.getWidth( this ), image.getHeight( this ) );
        }
    }

    public void update( Graphics g )
    {
        paint( g );
    }

    public Dimension getPreferredSize()
    {
        //return getMinimumSize();
        return new Dimension( imageWidth, imageHeight );
    }
}
