import java.net.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;


/**
 Pop3 mail server.
 **/

public class Pop3Server extends Server
{
    Letters letters;

    void transmitMail( PrintWriter to, String data ) throws java.io.IOException
    {
        sendAndDebug( to, "+OK "+data.length()+" octets" );
        to.print( data );
        to.print( cr + "." + cr );
        to.flush();
    }

    void result( PrintWriter to, boolean res ) throws java.io.IOException
    {
        if ( res )
        {
            sendAndDebug( to, "+OK" );
        }
        else
        {
            sendAndDebug( to, "-ERR Try Again" );
        }
    }

    Letters locateLetter( PrintWriter to, String recipient, String argument )
        throws java.io.IOException
    {
        Letters tempLtrs;

        if ( ( recipient == null ) || ( argument == null ) )
        {
            return null;
        }

        tempLtrs = letters.messageNumber( recipient,
                        new Integer( firstWord( argument ) ).intValue() );

        if ( tempLtrs == null )
        {
            result( to, false );
        }

        return tempLtrs;
    }

    String uid( String y )
    {
        CRC32 xx = new CRC32();
        int x = 0;

        xx.reset();

        while ( x < y.length() )
        {
            xx.update( (int)y.charAt( x ) );
            x++;
        }

        return Long.toHexString( xx.getValue() ) +
               Integer.toHexString( y.hashCode() );
    }

    /**
     Main server function.  This is called from the Server super class
     **/

    public void runServer( Socket localSocket )
        throws java.io.IOException, java.net.SocketException
    {
        BufferedReader from;
        PrintWriter to;
        String httpText;
        int inx;
        Letters tempLtrs;
        String recipient = "nobody";
        boolean validUser = false;
        String command;
        String argument;
        Properties users;
        boolean working = true;
        String portName = "none";
        int tLength;
        String passStuff;
        String totalPass;

        from = new BufferedReader( new InputStreamReader( localSocket.getInputStream() ) );
        to   = new PrintWriter( new OutputStreamWriter( localSocket.getOutputStream() ), true );

        users = loadUsers();

        localSocket.setSoTimeout( socketTimeout );
        portName = localSocket.getInetAddress().toString();

        if ( monitorConnect )
        {
            log.write( serverName+": "+ portName+ " connected" );
        }
        else
        {
            debugLog( serverName+": "+ portName+ " connected" );
        }

        passStuff = "<" + (new Date()).toString() + "@" +
                    localSocket.getInetAddress().getLocalHost().toString() +
                    ">";

        sendAndDebug( to, "+OK " + localSocket.getInetAddress().getLocalHost().toString() +
                    " " + passStuff );

        while ( working )
        {
            httpText = from.readLine().toLowerCase();

            if ( httpText.length() == 0 ) /** Timeout **/
            {
                working = false;
            }

            debugLog( httpText );

            command  = firstWord( httpText ).toLowerCase();
            argument = notFirstWord( httpText ).toLowerCase();

            if ( command.equals( "user" ) )
            {
                result( to, true );
                recipient = argument;
            }
            else if ( command.equals( "pass" ) )
            {
                if ( users.getProperty( recipient, "." ).toLowerCase().equals( argument ) )
                {
                    result( to, true );
                    validUser = true;
                }
                else
                {
                    result( to, false );
                    log.write(serverName+": Illegal user: "+recipient+" "+argument );
                }
            }
            else if ( command.equals( "apop" ) )
            {
                recipient = firstWord( argument );
                totalPass = passStuff + users.getProperty( recipient, "." );

                md5 mdc = new md5( totalPass );
                mdc.calc();

                if ( mdc.toString().toLowerCase().equals( notFirstWord( argument ).toLowerCase() ) )
                {
                    result( to, true );
                    validUser = true;
                }
                else
                {
                    result( to, false );
                    log.write(serverName+": Illegal user: "+recipient+" "+argument );
                }
            }
            else if ( command.equals( "last" ) )
            {
                sendAndDebug( to, "+OK 0" ); // Always new messages
            }
            else if ( command.equals( "rset" ) )
            {
                letters.unmarkDelete( recipient );
                result( to, true );
            }
            else if ( command.equals( "quit" ) )
            {
                result( to, true );
                tempLtrs = letters.first( recipient );
                tempLtrs.delete( recipient );
                letters.save();
                working = false;
            }
            else if ( command.equals( "noop" ) )
            {
                result( to, true );
            }
            else if ( validUser )
            {
                if ( command.equals( "stat" ) )
                {
                    tempLtrs = letters.first( recipient );
                    tLength = 0;

                    while ( tempLtrs != null )
                    {
                        tLength += tempLtrs.getBody( true ).length();
                        tempLtrs = tempLtrs.nextLetter( recipient );
                    }

                    sendAndDebug( to, "+OK "+letters.number( recipient )+" "+
                                tLength + " messages/octets" );
                }
                else if ( command.equals( "uidl" ) )
                {
                    if ( httpText.equals( "uidl" ) )
                    {
                        result( to, true );
                        tempLtrs = letters.first( recipient );
                        inx = 1;

                        while ( tempLtrs != null )
                        {
                            sendAndDebug( to, inx + " " + tempLtrs.uid );
                            tempLtrs = tempLtrs.nextLetter( recipient );
                            inx++;
                        }

                        sendAndDebug( to, "." );
                    }
                    else
                    {
                        sendAndDebug( to, "+OK "+argument+
                                    " " + letters.messageNumber( recipient,
                                    new Integer( argument ).intValue() ).uid );
                    }
                }
                else if ( command.equals( "list" ) )
                {
                    if ( httpText.equals( "list" ) )
                    {
                        result( to, true );
                        tempLtrs = letters.first( recipient );
                        inx = 1;

                        while ( tempLtrs != null )
                        {
                            sendAndDebug( to, inx + " " +
                                          tempLtrs.getBody( true ).length() );
                            tempLtrs = tempLtrs.nextLetter( recipient );
                            inx++;
                        }

                        sendAndDebug( to, "." );
                    }
                    else
                    {
                        tempLtrs = locateLetter( to, recipient, argument );

                        if ( tempLtrs != null )
                        {
                            sendAndDebug( to, "+OK " + argument + " " +
                                        tempLtrs.getBody( true ).length() );
                        }
                    }
                }
                else if ( command.equals( "dele" ) )
                {
                    tempLtrs = locateLetter( to, recipient, argument );

                    if ( tempLtrs != null )
                    {
                        tempLtrs.markDelete();
                        result( to, true );
                    }
                }
                else if ( command.equals( "top" ) ) // New code
                {
                    tempLtrs = locateLetter( to, recipient, argument );

                    if ( tempLtrs != null )
                    {
                        transmitMail( to, tempLtrs.top( new Integer( notFirstWord( argument ) ).intValue() ) );
                    }
                }
                else if ( command.equals( "retr" ) )
                {
                    tempLtrs = locateLetter( to, recipient, argument );

                    if ( tempLtrs != null )
                    {
                        transmitMail( to, tempLtrs.getBody( true ) );
                    }
                }
                else
                {
                    log.write( serverName+": "+portName+" "+recipient+" tried: "+httpText );
                    result( to, false );
                }
            }
            else
            {
                log.write( serverName+": "+recipient+" tried: "+httpText );
                result( to, false );
            }
        }
    }

    /**
     Creates and starts Pop3 server
     **/

    public Pop3Server( Letters lettersx, dixie logx )
    {
        letters    = lettersx;
        log        = logx;
        port       = 110;
        serverName = "Pop3";

        startServer();
    }
}


