import java.net.*;
import java.io.*;
import java.util.*;
import java.lang.Class;

/**
 Smtp mail server.
 **/

public class SmtpServer extends Server
{
    static int     maxMailServers = 10;        // Lots of mail servers
    Letters        letters;
    static String  outgoingSmtp;               // Own outgoing server
    static String  phantomDomain;

    String getPhantomDomain()
    {
        return phantomDomain;
    }

    void setPhantomDomain( String newPhantom )
    {
        phantomDomain = newPhantom;
        log.write( serverName+": New phantom domain: "+newPhantom );
    }

    int getMaxMailServers()
    {
        return maxMailServers;
    }

    void setMaxMailServers( int newMax )
    {
        maxMailServers = newMax;
        log.write( serverName+": New maximum # mail servers: "+newMax );
    }

    static public String getOutgoingSmtp()
    {
        return outgoingSmtp;
    }

    void setOutgoingSmtp( String newSmtpServer )
    {
        outgoingSmtp = newSmtpServer;
        log.write( serverName+": New outgoing server: "+outgoingSmtp );
    }

    String commaParser( String item, int position )
    {
        StringBuffer parsed = new StringBuffer();
        int commasParsed = 0;
        int inx = 0;

        /** Skip commas **/

        while ( position > commasParsed )
        {
            while ( ( inx < item.length() ) && ( item.charAt(inx) != ',' ) )
            {
                inx++;
            }

            inx++; // Skip a comma
            commasParsed++;
        }

        while ( ( inx < item.length() ) && ( item.charAt(inx) != ',' ) )
        {
            parsed.append( item.charAt(inx) );
            inx++;
        }

        return parsed.toString();
    }


    public void runServer( Socket localSocket )
        throws java.io.IOException, java.net.SocketException
    {
        Properties users;
        Properties autoReply;
        BufferedReader from;
        PrintWriter to;
        String httpText;
        int inx;
        boolean loading;
        StringBuffer text;
        String command;
        String argument;
        boolean working = true;
        Forwarder forwarder;
        String thisServerName;
        String recipientName;
        String recipientDomain;
        int numberOfRecipients = 0;
        int maxRecipients      = 30;
        String recipient[] = new String[maxRecipients];
        String returnTo        = "nobody";
        String autoReplyFile;
        String portName;
        String okResponse;
        StringBuffer header;
        String headerAttach = " - "+log.getVersionString() + " " +
               log.getHomepageString() + cr;
        boolean extensionRun;

        from = new BufferedReader( new InputStreamReader( localSocket.getInputStream() ) );
        to   = new PrintWriter( new OutputStreamWriter( localSocket.getOutputStream() ), true );

        localSocket.setSoTimeout( socketTimeout );
        portName       = localSocket.getInetAddress().toString();
        thisServerName = localSocket.getInetAddress().getLocalHost().toString();
        header         = new StringBuffer( "Received: from " + thisServerName + 
                                           headerAttach );

        if ( monitorConnect )
        {
            log.write( serverName+": "+ portName+ " connected" );
        }
        else
        {
            debugLog( serverName + ": " + portName );
            debugLog( serverName + ": " + thisServerName );
        }

        if ( java.lang.Thread.activeCount() <= maxMailServers )
        {
            sendAndDebug( to, "220 Welcome!" );
        }
        else
        {
            sendAndDebug( to, "421 Too many connections - try later." );
            log.write( serverName+": "+ portName+ " too many connections" );
            working = false;
        }

        while ( working )
        {
            httpText = from.readLine();

            if ( httpText.length() == 0 ) /** Timeout **/
            {
                working = false;
            }

            command    = firstWord( httpText ).toLowerCase();
            argument   = notFirstWord( httpText ).toLowerCase();
            okResponse = "250 ok: " + httpText;

            if ( ( command.equals( "helo" ) ) ||
                 ( command.equals( "noop" ) ) )
            {
                sendAndDebug( to, okResponse );
            }
            else if ( command.equals( "rset" ) )
            {
                sendAndDebug( to, okResponse );
                numberOfRecipients = 0;
            }
            else if ( command.equals( "quit" ) )
            {
                sendAndDebug( to, "221 ok, later dude: "+ httpText );
                working = false;
            }
            else if ( command.equals( "mail" ) )
            {
                sendAndDebug( to, okResponse );
                returnTo = smtp.wholeUser( argument );
            }
            else if ( command.equals( "rcpt" ) )
            {
                sendAndDebug( to, okResponse );

                if ( numberOfRecipients < maxRecipients )
                {
                    recipient[numberOfRecipients] = smtp.wholeUser( httpText );
                    numberOfRecipients++;
                }
            }
            else if ( command.equals( "data" ) )
            {
                sendAndDebug( to, "354 Enter your mail." );
                loading = true;
                text = new StringBuffer();

                while ( loading )
                {
                    httpText = from.readLine();

                    if ( httpText.equals( "." ) )
                    {
                        sendAndDebug( to, okResponse );
                        loading = false;

                        text.insert( 0, header.toString() );

                        for ( inx = 0; inx < numberOfRecipients; inx++ )
                        {
                            recipientName   = smtp.user( recipient[inx] );
                            recipientDomain = smtp.domain( recipient[inx] );

                            if ( ( thisDomain.toLowerCase().startsWith( recipientDomain.toLowerCase() ) ) ||
                                 ( ( recipientDomain.toLowerCase().equals( phantomDomain ) ) ) &&
                                   ( !phantomDomain.equals( log.getNullProperty() ) ) )
                            {
                                autoReply     = loadAutoReply();
                                autoReplyFile = autoReply.getProperty( recipientName, "." ).toLowerCase();

                                // Code to go through extensions

                                String extension;
                                BufferedReader win;
                                extensionRun = false;

                                try
                                {
                                    win = new BufferedReader(new FileReader( "extend" ) );

                                    while ( win.ready() )
                                    {
                                        extension = win.readLine();

                                        if ( recipientName.equals( commaParser( extension, 0 ) ) )
                                        {
                                            Class xclass = java.lang.Class.forName( commaParser( extension, 1 ) );
                                            Extension runFunct = (Extension)xclass.newInstance();
                                            runFunct.execute( log, thisDomain,  recipient[inx], returnTo,
                                                              text.toString(), commaParser( extension, 2 ) );
                                        }
                                    }

                                    win.close();
                                }
                                catch ( Exception e ) /** File not found **/
                                { }

                                if ( !extensionRun ) // Normal mail received
                                {
                                    letters.add( recipientName, text.toString() );
                                    letters.save();
                                }
                            }
                            else //Forward to some other mail server
                            {
                                log.write(serverName + ": Forwarding to "+outgoingSmtp );
                                forwarder = new Forwarder( outgoingSmtp, recipient[inx],
                                    returnTo, text.toString(), log,
                                    "Outbound to "+recipientDomain, letters, true );
                            }
                        }

                        text = new StringBuffer();
                    }
                    else
                    {
                        text.append( httpText+cr );
                    }
                }
            }
            else if ( firstWord( httpText ).equals( "" ) )
            {   }
            else
            {
                log.write(serverName+": !"+portName+": "+httpText );
                sendAndDebug( to, "502 Command not implemented" );
            }
        }
    }

    public SmtpServer( Letters lettersx, dixie logx )
    {
        letters       = lettersx;
        log           = logx;
        port          = 25;
        serverName    = "Smtp";
        phantomDomain = logx.getNullProperty();
        outgoingSmtp  = logx.getNullProperty();

        startServer();
    }
}


