import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 Simple class to start and control the mail (Smtp, Pop3, and Epass) servers.
 Comments:
 970915 Original code, lots of modifications
 971006 Added real top processing
 971027 More cleanup, focus on SMTP, forwarding
 98xxxx Made into windows driven stuff
 990110 Even more cleanup
 **/


/**
 * Create a frame that can be closed; only used if run standalone.
 */

class dixie extends CFrame implements ActionListener, ItemListener
{
    private MenuBar menu;
    private Letters letters;
    private SmtpServer mailTask;
    private Pop3Server popTask;
    private EpassServer passTask;
    private FileWriter wout;
    private boolean debugDixie = true;
    private Form f;
    private Properties dixieProps;
    private CheckboxMenuItem debugBox;
    private CheckboxMenuItem monitorBox;

    private String dixiePropsString         = "DixieMail.cfg";
    private String versionString            = "DixieMail v1.5";
    private String homepageString           = "http://welcome.to/reality";
    private String monitorString            = "Monitor";
    private String usersString              = "Users";
    private String debugString              = "Debug";
    private String monitorConnectString     = "Monitor Connect";
    private String listUsersString          = "List Users";
    private String addUsersString           = "Add/Change User Information";
    private String deleteUsersString        = "Delete User";
    private String clearLogString           = "Clear Log";
    private String listForwardString        = "List Forwarding Addresses";
    private String addForwardString         = "Add/Change Forwarding Address";
    private String deleteForwardString      = "Delete Forwarding Address";
    private String listExtensionsString     = "List Extensions";
    private String forwardString            = "Forward";
    private String extensionsString         = "Extensions";
    private String passwordEnterUser        = "User's Name";
    private String passwordNewPassword      = "New Password";
    private String newAddressString         = "Forward To";
    private String addExtensionString       = "Add Extension";
    private String deleteExtensionString    = "Remove Extension";
    private String addExtensionInstruction  = "email,class,parameter";
    private String changeOutgoingSmtpString = "Change Gateway SMTP Server";
    private String optionsString            = "Options";
    private String showSplashScreenString   = "Show Splash Screen";
    private String showSettingsString       = "Show Settings";
    private String changePhantomString      = "Change Phantom Domain";
    private String lastValue    = "none";
    private String nullProperty = "<none>";

    private String outgoingName          = "outgoing";
    private String phantomName           = "phantom";
    private String fwdFileName           = "Fwd";
    private String usersFileName         = "users";
    private String extendFileName        = "extend";
    private String usersFileDescription  = "Users Information";
    private String configFileDescription = "DixieMail Configuration";

    String getNullProperty()
    {
        return nullProperty;
    }

    String getVersionString()
    {
        return versionString;
    }

    String getHomepageString()
    {
        return homepageString;
    }

    void deleteExtension( String value )
    {
        String extension;
        BufferedReader win;
        BufferedWriter out;
        StringBuffer newExtension = new StringBuffer();

        try
        {
            win = new BufferedReader(new FileReader( extendFileName ) );

            while ( win.ready() )
            {
                extension = win.readLine();

                if ( !( value.equals( commaParser( extension, 0 ) ) ) )
                {
                    newExtension.append( extension +"\n" );
                }
            }

            win.close();

            writeFile( extendFileName, newExtension.toString() );
        }
        catch ( Exception e ) /** File not found **/
        { }
    }

    void addExtension( String value )
    {
        BufferedWriter out;
        StringBuffer newExtension = new StringBuffer();

        deleteExtension( commaParser( value, 0 ) ); // Remove duplicates

        try
        {
            newExtension.append( loadExtension() + value +"\n" );
            writeFile( extendFileName, newExtension.toString() );
        }
        catch ( Exception e ) /** File not found **/
        { }
    }

    void writeFile( String filename, String data )
    {
        BufferedWriter out;

        try
        {
            out = new BufferedWriter( new FileWriter( filename ) );
            out.write( data, 0, data.length() );
            out.close();
        }
        catch ( Exception e ) /** Could not write file **/
        { }
    }

    String loadExtension()
    {
        String extension;
        BufferedReader win;
        StringBuffer newExtension = new StringBuffer();

        try
        {
            win = new BufferedReader(new FileReader( extendFileName ) );

            while ( win.ready() )
            {
                newExtension.append( win.readLine()+"\n" );
            }

            win.close();
        }
        catch ( Exception e ) /** File not found **/
        { }

        return newExtension.toString();
    }

    String commaParser( String item, int position )
    {
        StringBuffer parsed = new StringBuffer();
        int commasParsed = 0;
        int inx = 0;

        /** Skip commas **/

        while ( position > commasParsed )
        {
            while ( ( inx < item.length() ) && ( item.charAt(inx) != ',' ) )
            {
                inx++;
            }

            inx++; // Skip a comma
            commasParsed++;
        }

        while ( ( inx < item.length() ) && ( item.charAt(inx) != ',' ) )
        {
            parsed.append( item.charAt(inx) );
            inx++;
        }

        return parsed.toString();
    }

    /*****************************************************************

    Responses to commands

    *****************************************************************/
  
    public void commandResponse( String why, String value )
    {
        write( why+" "+value );

        if ( why.equals( deleteUsersString ) )
        {
            Properties props = loadProps( usersFileName );
            props.remove( value );
            saveProps( props, usersFileName, usersFileDescription );
        }
        else if ( ( why.equals( deleteForwardString ) ) ||
                  ( why.equals( deleteExtensionString ) ) )
        {
            deleteExtension( value );
        }
        else if ( why.equals( passwordEnterUser ) )
        {
            InputDialog x = new InputDialog( this, passwordNewPassword );
        }
        else if ( why.equals( passwordNewPassword ) )
        {
            Properties props = loadProps( usersFileName );
            props.remove( lastValue );
            props.put( lastValue, value );
            saveProps( props, usersFileName, usersFileDescription );
        }
        else if ( why.equals( addForwardString ) )
        {
            InputDialog x = new InputDialog( this, newAddressString );
        }
        else if ( why.equals( newAddressString ) )
        {
            addExtension( lastValue+"," + fwdFileName + ","+ value );
        }
        else if ( why.equals( addExtensionInstruction ) )
        {
            addExtension( value );
        }
        else if ( why.equals( changeOutgoingSmtpString ) )
        {
            if ( value.length() == 0 )
            {
                value = nullProperty;
            }

            mailTask.setOutgoingSmtp( value );
            dixieProps.put( outgoingName, value );
        }
        else if ( why.equals( changePhantomString ) )
        {
            if ( value.length() == 0 )
            {
                value = nullProperty;
            }

            mailTask.setPhantomDomain( value );
            dixieProps.put( phantomName, value );
        }

        lastValue = value;

        saveProps( dixieProps, dixiePropsString, configFileDescription );
                
    }

    public void actionPerformed(ActionEvent e)
    {
        String attachment;
        String message;
        OutputDialog od;
        String command = e.getActionCommand();
        int inx;
        InetAddress here;
        String tempString;

        if ( command.equals( listUsersString ) )
        {
            Properties h = loadProps( usersFileName );

            od = new OutputDialog( this, listUsersString );

            for (Enumeration en = h.keys() ; en.hasMoreElements() ;) 
            {
	          String key = (String)en.nextElement();
	          String val = (String)h.get(key);
                  od.append( key );
            }
        }
        else if ( command.equals( listForwardString ) )
        {
            od = new OutputDialog( this, listExtensionsString );
            BufferedReader win;

            try
            {
                win = new BufferedReader(new FileReader( extendFileName ) );

                while ( win.ready() )
                {
                    tempString = win.readLine();

                    if ( commaParser( tempString, 1 ).equals( fwdFileName ) )
                    {
                        od.append( commaParser( tempString, 0 ) + " = " +
                                   commaParser( tempString, 2 ) );
                    }
                }

                win.close();
            }
            catch ( Exception ex ) /** File not found **/
            { }
        }
        else if ( command.equals( listExtensionsString ) )
        {
            od = new OutputDialog( this, listExtensionsString );
            BufferedReader win;

            try
            {
                win = new BufferedReader(new FileReader( extendFileName ) );

                while ( win.ready() )
                {
                    od.append( win.readLine() );
                }

                win.close();
            }
            catch ( Exception ex ) /** File not found **/
            { }	      
        }
        else if ( command.equals( clearLogString ) )
        {
            f.clearLog();
        }
        else if ( command.equals( addUsersString ) )
        {
            new InputDialog( this, passwordEnterUser );
        }
        else if ( ( command.equals( deleteUsersString ) )         ||
                  ( command.equals( addForwardString ) )          ||
                  ( command.equals( deleteForwardString ) )       ||
                  ( command.equals( deleteExtensionString ) )     ||
                  ( command.equals( changeOutgoingSmtpString ) )  ||
                  ( command.equals( changePhantomString ) ) )
        {
            new InputDialog( this, command );
        }
        else if ( command.equals( addExtensionString ) )
        {
            new InputDialog( this, addExtensionInstruction );
        }
        else if ( command.equals( showSplashScreenString ) )
        {
            new Splash();
        }
        else if ( command.equals( showSettingsString ) )
        {
            od = new OutputDialog( this, command );
            inx = 0;

            od.append( "Version: "+versionString );
            od.append( "DixieMail Homepage: "+homepageString );

            try
            {
                here = InetAddress.getLocalHost();
                od.append( "Location: "+ here.getHostAddress() );
                od.append( "Name: "+here.getHostName() );

                try
                {
                    while ( true ) // Parse whole array
                    {
                        od.append( "    a.k.a.: "+
                                   InetAddress.getAllByName( here.getHostAddress() )[inx++]);
                    }
                }
                catch ( java.lang.ArrayIndexOutOfBoundsException arrayex )
                { }
            }
            catch ( java.net.UnknownHostException uh )
            {
                od.append( "Note: Could not get local host information" );
            }

            od.append( "Outgoing SMTP: "+mailTask.getOutgoingSmtp() );
            od.append( "SMTP Max Servers: "+mailTask.getMaxMailServers() );
            od.append( "SMTP Phantom Domain: "+mailTask.getPhantomDomain() );
        }

        saveProps( dixieProps, dixiePropsString, configFileDescription );
    }

    public void itemStateChanged( ItemEvent e )
    {
        String command = (String)e.getItem();
        boolean state = true;

        if ( command.equals( debugString ) )
        {
            state = debugBox.getState();

            mailTask.setDebug( state );
            popTask.setDebug( state );
            passTask.setDebug( state );
        }
        else if ( command.equals( monitorConnectString ) )
        {
            state = monitorBox.getState();

            mailTask.setMonitorConnect( state );
            popTask.setMonitorConnect( state );
            passTask.setMonitorConnect( state );
        }
    }

    public Letters getLetters()
    {
        return letters;
    }

    public static void main( String argv[] )
    {
        new dixie();
    }


    void saveProps( Properties props, String filename, String text )
    {
        try
        {
            try
            {
                File wFile = new File( filename );
                FileOutputStream fos = new FileOutputStream( wFile );
                props.save( fos, text );
                fos.close();
            }
            catch ( FileNotFoundException e )
            {  }
        }
        catch ( IOException e )
        {  }
    }


    Properties loadProps( String propname )
    {
        Properties temp = new Properties();

        try
        {
            try
            {
                File readFile = new File( propname );
                FileInputStream fis = new FileInputStream( readFile );
                temp.load( fis );
                fis.close();
            }
            catch ( FileNotFoundException e )
            {  }
        }
        catch ( IOException e )
        {  }

        return temp;
    }

    public dixie()
    {
        Menu   subMenu;
        CheckboxMenuItem cbox;
        String tempProperty;

        dixieProps = loadProps( dixiePropsString );
        setTitle( versionString );
        setIconImage( Toolkit.getDefaultToolkit().getImage( setup.getIcon() ) );
        addWindowListener( this );

        // Create the menu bar

        menu = new MenuBar();

        subMenu = new Menu( monitorString );
        subMenu.add( clearLogString );
        debugBox = new CheckboxMenuItem( debugString );
        debugBox.addItemListener( this );
        subMenu.add( debugBox );
        monitorBox = new CheckboxMenuItem( monitorConnectString );
        monitorBox.addItemListener( this );
        subMenu.add( monitorBox );
        subMenu.addActionListener( this );
        menu.add( subMenu );

        subMenu = new Menu( usersString );      
        subMenu.add( listUsersString );
        subMenu.add( addUsersString );
        subMenu.add( deleteUsersString );
        subMenu.addActionListener( this );
        menu.add( subMenu );

        subMenu = new Menu( forwardString );
        subMenu.add( listForwardString );
        subMenu.add( addForwardString );
        subMenu.add( deleteForwardString );
        subMenu.addActionListener( this );
        menu.add( subMenu );

        subMenu = new Menu( extensionsString );
        subMenu.add( listExtensionsString );
        subMenu.add( addExtensionString );
        subMenu.add( deleteExtensionString );
        subMenu.addActionListener( this );
        menu.add( subMenu );

        subMenu = new Menu( optionsString );
        subMenu.add( showSettingsString );
        subMenu.add( changeOutgoingSmtpString );
        subMenu.add( changePhantomString );
        subMenu.add( showSplashScreenString );
        subMenu.addActionListener( this );
        menu.add( subMenu );
        this.setMenuBar( menu );

        f = new Form( this );

        new Splash();

        add( f );
        pack();
        center();
        show();

        letters = new Letters();
        letters.load();

        try
        {
            wout = new FileWriter( "mail.log", false );
        }
        catch( java.io.IOException e )
        {
            write("Could not open log file");
        }

        mailTask = new SmtpServer( letters, this );
        popTask  = new Pop3Server( letters, this );
        passTask = new EpassServer( this );

        /** Set user defined variables **/

        tempProperty = dixieProps.getProperty( outgoingName, nullProperty );

        if ( !tempProperty.equals( nullProperty ) )
        {
            mailTask.setOutgoingSmtp( tempProperty );
        }

        tempProperty = dixieProps.getProperty( phantomName, nullProperty );

        if ( !tempProperty.equals( nullProperty ) )
        {
            mailTask.setPhantomDomain( tempProperty );
        }
    }

    /**
     Writes data to the mail.log file
     **/

    public void write( String data )
    {
        if ( debugDixie )
        {
            f.append( (new Date()).toString() + " " + data );
        }

        try
        {
            wout.write( (new Date()).toString() + " " + data + "\n" );
            wout.flush();
        }
        catch( java.io.IOException e )
        {
            f.append( (new Date()).toString() +
                      " Could not write to log file" );
        }
    }

    /**
     Starts the Smtp, Pop3, and Password Servers.
     Note that servers generally start automatically when created, so
     the constructor should take care of this the first time.
     **/

    public void start()
    {
        mailTask.startServer();
        popTask.startServer();
        passTask.startServer();
    }

    /**
     Stops the Smtp, Pop3, and Password Servers
     **/

    public void stop()
    {
        write( "Stopping DixieMail Server..." );
        mailTask.stopServer();
        popTask.stopServer();
        passTask.stopServer();

        while ( !mailTask.stopped ||
                !popTask.stopped ||
                !passTask.stopped )
        {
            try
            {
                Thread.sleep( 100 );
            }
            catch ( java.lang.InterruptedException e )
            {
            }
        }
    }

    public void windowClosing( WindowEvent e )
    {
        stop();
        this.setVisible( false );
        System.exit(0);
    }
}


/**
 * A form for obtaining user input. Customize this for your application, just
 * as you would customize an HTML form for a Web-based e-mail application.
 */

class Form extends Panel
{
     private TextArea msgBodyArea;
     private int nRows;
     private boolean stop = false;
     private dixie mainPgm;

 /**
  * The constructor
  */

     synchronized public void clearLog()
     {
         msgBodyArea.setText( "" );
     }

     synchronized public void append( String text )
     {
        msgBodyArea.setText( msgBodyArea.getText()+text+"\n" );
        msgBodyArea.setRows( ++nRows );
     }

    public Form( dixie mainProgram )
    {
        BorderLayout pbl;
        BorderLayout formbl;

        mainPgm = mainProgram;
        setLayout( formbl = new BorderLayout() );

        // Create a panel to put the text fields and button on
        Panel p         = new Panel();

        p.setLayout( pbl = new BorderLayout() );

        pbl.setVgap( 3 );
        formbl.setVgap( 2 );
        formbl.setHgap( 2 );

        // Instantiate all the elements, and add them to their containers...

        msgBodyArea  = new TextArea();

        p.add( msgBodyArea, "Center" );
        add(p);

        nRows = 1;

        msgBodyArea.setRows( nRows );
    }
}

class InputDialog extends CFrame
{
    private dixie thisParent;
    private String whyString;

    public InputDialog( dixie parent, String why )
    {
        setTitle( why );

        thisParent = parent;
        whyString  = why;
        add( new DialogForm( this, why ) );
        pack();
        center();
        show();
    }

    public void done( String value )
    {
        thisParent.commandResponse( whyString, value );
        this.dispose();
    }
}

class OutputDialog extends CFrame
{
    private dixie thisParent;
    private String whyString;
    private Form outData;

    public void append( String string )
    {
        outData.append( string );
    }

    public OutputDialog( dixie parent, String why )
    {
        setTitle( why );

        thisParent = parent;
        whyString  = why;
        add( outData = new Form( parent ) );
        pack();
        center();
        show();
        addWindowListener( this );
    }

    public void done( String value )
    {
        thisParent.commandResponse( whyString, value );
        this.dispose();
    }
}


class DialogForm extends Panel implements ActionListener
{
     private TextField toField;
     private Button searchButton;
     private InputDialog parentFrame;

 /**
  * The constructor
  */

    public DialogForm( InputDialog pf, String why )
    {
        BorderLayout formbl;

        parentFrame = pf;
        setLayout( formbl = new BorderLayout() );

        formbl.setVgap( 2 );
        formbl.setHgap( 2 );

        // Instantiate all the elements, and add them to their containers...

        add( searchButton = new Button( why ), "West" );
        add( toField      = new TextField(60), "Center" );

        searchButton.addActionListener( this );
    }

    public void actionPerformed(ActionEvent e)
    {
         parentFrame.done( toField.getText() );
    }
}
