/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageObserver;

public class ImageComponent
extends Canvas
implements ImageObserver {
    Image image;
    Image altImage;
    MediaTracker imageTracker = new MediaTracker(this);
    private String label;
    private int imageHeight;
    private int imageWidth;
    private boolean setup = false;
    private boolean altSetup = false;
    private boolean useAlt = false;

    public void useAlt(boolean bl) {
        this.useAlt = bl;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this.imageHeight = n5;
        this.imageWidth = n4;
        this.repaint();
        return false;
    }

    public int getHeight() {
        this.imageSetup();
        return this.imageHeight;
    }

    public int getWidth() {
        this.imageSetup();
        return this.imageWidth;
    }

    public void setAltImage(Image image) {
        if (this.altSetup) {
            this.imageTracker.removeImage(this.altImage, 1);
        }
        this.altImage = image;
        this.altSetup = true;
        this.imageTracker.addImage(this.altImage, 1);
        this.imageSetup();
    }

    public void setImage(Image image) {
        if (this.setup) {
            this.imageTracker.removeImage(this.image, 0);
        }
        this.image = image;
        this.setup = true;
        this.imageTracker.addImage(this.image, 0);
        this.imageSetup();
    }

    void imageSetup() {
        this.repaint();
        this.imageHeight = this.image.getHeight(this);
        this.imageWidth = this.image.getWidth(this);
    }

    public ImageComponent(Image image) {
        this.setImage(image);
    }

    public void paint(Graphics graphics) {
        this.setBackground(Color.black);
        if (this.useAlt) {
            if (this.altImage != null) {
                graphics.drawImage(this.altImage, 0, 0, this);
            } else {
                this.setBackground(Color.red);
            }
        } else {
            graphics.drawImage(this.image, 0, 0, this);
        }
        if (this.imageTracker.checkID(0, true)) {
            this.setSize(this.image.getWidth(this), this.image.getHeight(this));
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.imageWidth, this.imageHeight);
    }
}

