import java.net.*;
import java.io.*;
import java.util.*;

/**
 Epass type password server.
 **/

public class EpassServer extends Server
{
    /**
     Main runServer function.  This is called from the Server class
     **/

    public void runServer( Socket localSocket )
        throws java.io.IOException, java.net.SocketException
    {
        BufferedReader from;
        PrintWriter to;
        String httpText;
        String command;
        String argument;
        String userName  = ".";
        String oldPass   = ".";
        Properties users = loadUsers();
        boolean working  = true;

        from = new BufferedReader( new InputStreamReader( localSocket.getInputStream() ) );
        to   = new PrintWriter( new OutputStreamWriter( localSocket.getOutputStream() ), true );

        localSocket.setSoTimeout( socketTimeout );

        if ( monitorConnect )
        {
            log.write( serverName+": "+ localSocket.getInetAddress().toString()+ " connected" );
        }

        sendAndDebug( to, "220 EPass Server OK!" );

        while ( working )
        {
            httpText = from.readLine();

            sendAndDebug( to, "250 ok" );

            if ( httpText.length() == 0 ) /** Timeout **/
            {
                working = false;
            }

            command  = StringTools.firstWord( httpText ).toLowerCase();
            argument = StringTools.notFirstWord( httpText ).toLowerCase();

            if ( command.equals( "user" ) )
            {
                userName = argument;
            }
            else if ( command.equals( "pass" ) )
            {
                oldPass = argument;
            }
            else if ( command.equals( "newpass" ) )
            {
                if ( users.getProperty( userName, "." ).toLowerCase().equals( oldPass ) )
                {
                    log.write(serverName+": User "+userName+" changed password");
                    users.put( userName, argument );
                    saveUsers( users );
                }
                else
                {
                    log.write(serverName+": User "+userName+" tried to changed password using "+oldPass);
                }
            }
        }
    }

    /**
     Instantiates an Epass server
     **/

    public EpassServer( dixie logx )
    {
        log        = logx;
        port       = 106;
        serverName = "Epass";

        startServer();
    }
}


