import java.io.*;
import java.awt.*;
import java.awt.event.*;
import StringTools;

public class Extension implements ActionListener
{
    String cr = "\r\n"; // Make sure we always add these two
    String extendFileName = "extend";
    String extensionName  = "Extension";
    dixie  log;
    String thisDomain;
    String to;
    String from;
    String letter;
    String data;
    Menu   subMenu;

    private String extAddProp     = "extAdd";
    private String extDelProp     = "extDel";
    private String extListProp    = "extList";
    private String extAddHelpProp = "extAddHelp";
    private String extDelHelpProp = "extDelHelp";

    void addToFile( String filename, String text )
    {
        StringBuffer newData = new StringBuffer( StringTools.getFile( filename ) );
        newData.append( text );
        StringTools.saveFile( filename, newData.toString() );
    }

    boolean lineInFile( String filename, String start )
    {
        String data = StringTools.getFile( filename );
        int inx;

        for ( inx = 0; inx < numberOfLines( data ); inx++ )
        {
            if ( start.trim().equals( getLine( data, inx ).trim() ) )
            {
                return true;
            }
        }

        return false;
    }


    boolean inFile( String filename, String start )
    {
        String data = StringTools.getFile( filename );
        int inx;

        for ( inx = 0; inx < numberOfLines( data ); inx++ )
        {
            if ( getLine( data, inx ).trim().startsWith( start.trim() ) )
            {
                return true;
            }
        }

        return false;
    }

    boolean removeFrom( String filename, String start )
    {
        StringBuffer newData = new StringBuffer();
        String data = StringTools.getFile( filename );
        String lData;
        boolean retval = false;
        int iny;

        for ( iny = 0; iny < numberOfLines( data ); iny++ )
        {
            lData = getLine( data, iny );

            if ( lData.startsWith( start ) )
            {
                retval = true;
            }
            else
            {
                newData.append( lData+"\n" );
            }
        }

        if ( retval )
        {
            StringTools.saveFile( filename, newData.toString() );
        }

        return retval;
    }

    String getLine( String lines, int num )
    {
        int inx;
        int currentLine = 0;
        StringBuffer thisLine = new StringBuffer();

        for ( inx = 0; inx < lines.length(); inx++ )
        {
            if ( lines.charAt( inx ) == '\n' )
            {
                currentLine++;
            }
            else if ( lines.charAt( inx ) == '\r' )
            {
                // Do nothing
            }
            else if ( currentLine == num )
            {
                thisLine.append( lines.charAt( inx ) );
            }
        }

        return thisLine.toString();
    }

    int numberOfLines( String lines )
    {
        int currentLines = 0;
        int inx;

        if ( lines.length() > 0 )
        {
            currentLines++;
        }

        for ( inx = 0; inx < lines.length(); inx++ )
        {
            if ( lines.charAt( inx ) == '\n' )
            {
                currentLines++;
            }
        }

        return currentLines;
    }

    String argument( String thisLine )
    {
        int iny = 0;
        int maxArg = 255;
        StringBuffer retVal = new StringBuffer();

        while ( ( iny < thisLine.length() ) &&
                ( iny < maxArg ) &&
                ( thisLine.charAt( iny ) != ' ' ) )
        {
            iny++;
        }

        while ( ( iny < thisLine.length() ) &&
                ( iny < maxArg ) &&
                ( thisLine.charAt(iny) == ' ' ) )
        {
            iny++;
        }

        while ( ( iny < thisLine.length() ) &&
                ( iny < maxArg ) )
        {
            retVal.append( thisLine.charAt( iny ) );
            iny++;
        }

        return retVal.toString();
    }

    public Extension()
    {
    }

    public Extension( dixie logx )
    {
        log = logx;
    }

    public void commandResponse( String why, String value )
    {
        if ( why.equals( log.getString( extAddProp ) ) )
        {
            addExtension( value );
        }
        else if ( why.equals( log.getString( extDelProp ) ) )
        {
            deleteExtension( value );
        }
    }

    String loadExtension()
    {
        String extension;
        BufferedReader win;
        StringBuffer newExtension = new StringBuffer();

        try
        {
            win = new BufferedReader(new FileReader( extendFileName ) );

            while ( win.ready() )
            {
                newExtension.append( win.readLine()+"\n" );
            }

            win.close();
        }
        catch ( Exception e ) /** File not found **/
        { }

        return newExtension.toString();
    }

    void deleteExtension( String value )
    {
        String extension;
        BufferedReader win;
        BufferedWriter out;
        StringBuffer newExtension = new StringBuffer();

        try
        {
            win = new BufferedReader(new FileReader( extendFileName ) );

            while ( win.ready() )
            {
                extension = win.readLine();

                if ( !( value.equals( StringTools.commaParser( extension, 0 ) ) ) )
                {
                    newExtension.append( extension +"\n" );
                }
            }

            win.close();

            StringTools.saveFile( extendFileName, newExtension.toString() );
        }
        catch ( Exception e ) /** File not found **/
        { }
    }



    void addExtension( String value )
    {
        BufferedWriter out;
        StringBuffer newExtension = new StringBuffer();

        deleteExtension( StringTools.commaParser( value, 0 ) ); // Remove duplicates

        try
        {
            newExtension.append( loadExtension() + value +"\n" );
            StringTools.saveFile( extendFileName, newExtension.toString() );
        }
        catch ( Exception e ) /** File not found **/
        { }
    }

    public void actionPerformed( ActionEvent e )
    {
        String command = e.getActionCommand();

        if ( command.equals( log.getString( extAddProp ) ) )
        {
            new InputDialog( this,
                             log.getString( extAddProp ),
                             log.getString( extAddProp ),
                             log.getString( extAddHelpProp ) );
        }
        else if ( command.equals( log.getString( extDelProp ) ) )
        {
            new InputDialog( this,
                             log.getString( extDelProp ),
                             log.getString( extDelProp ),
                             log.getString( extDelHelpProp ) );
        }
        else if ( command.equals( log.getString( extListProp ) ) )
        {
            OutputDialog od = new OutputDialog( log.getString( extListProp ) );
            BufferedReader win;

            try
            {
                win = new BufferedReader(new FileReader( extendFileName ) );

                while ( win.ready() )
                {
                    od.append( win.readLine() );
                }

                win.close();
            }    
            catch ( Exception ex ) /** File not found **/
            { }
        }
    }
            

    public Menu getMenu()
    {
        Menu subMenu = new Menu( "Extension" );
        subMenu.add( log.getString( extAddProp ) );
        subMenu.add( log.getString( extDelProp ) );
        subMenu.add( log.getString( extListProp ) );
        subMenu.addActionListener( this );

        return subMenu;
    }

    public void execute( dixie  log, String thisDomain, String to,
                         String from, String letter, String data )
    {
    }
}


