import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 Mail Forwarder Server
 **/

public class Fwd extends Extension implements Runnable, ActionListener
{
    String lastValue;

    private String listFwdProp    = "fwdList";
    private String addFwdProp     = "fwdFrom";
    private String toFwdProp      = "fwdTo";
    private String delFwdProp     = "fwdDel";
    private String addFwdHelpProp = "fwdFromHelp";
    private String toFwdHelpProp  = "fwdToHelp";
    private String delFwdHelpProp = "fwdDelHelp";

    public Fwd( dixie logx )
    {
        log     = logx;
        subMenu = new Menu( "Fwd" );
        subMenu.add( log.getString( listFwdProp ) );
        subMenu.add( log.getString( addFwdProp ) );
        subMenu.add( log.getString( delFwdProp ) );
        subMenu.addActionListener( this );
        extensionName = "Fwd";
    }

    public void actionPerformed( ActionEvent e )
    {
        String command = e.getActionCommand();
        String tempString;

        log.write( extensionName + ": " + command );

        if ( command.equals( log.getString( listFwdProp ) ) )
        {
            OutputDialog od = new OutputDialog( command );
            BufferedReader win;

            try
            {
                win = new BufferedReader(new FileReader( extendFileName ) );

                while ( win.ready() )
                {
                    tempString = win.readLine();
                    if ( StringTools.commaParser( tempString, 1 ).equals( extensionName ) )
                    {
                        od.append( StringTools.commaParser( tempString, 0 ) + " = " +
                                   StringTools.commaParser( tempString, 2 ) );
                    }
                }

                win.close();
            }
            catch ( Exception ex ) /** File not found **/
            { }
        }
        else if ( command.equals( log.getString( addFwdProp ) ) )
        {
            new InputDialog( this,
                             log.getString( addFwdProp ),
                             log.getString( addFwdProp ),
                             log.getString( addFwdHelpProp ) );
        }
        else if ( command.equals( log.getString( delFwdProp ) ) )
        {
            new InputDialog( this,
                             log.getString( delFwdProp ),
                             log.getString( delFwdProp ),
                             log.getString( delFwdHelpProp ) );
        }

    }

    public void commandResponse( String why, String value )
    {
        if ( why.equals( log.getString( toFwdProp ) ) )
        {
            addExtension( lastValue+","+extensionName+","+value );
        }
        else if ( why.equals( log.getString( addFwdProp ) ) )
        {
            new InputDialog( this,
                             log.getString( toFwdProp ),
                             log.getString( toFwdProp ),
                             log.getString( toFwdHelpProp ) );
        }
        else if ( why.equals( log.getString( delFwdProp ) ) )
        {
            deleteExtension( value );
        }

        lastValue = value;
    }

    public Menu getMenu()
    {
        return subMenu;
    }

    public void execute( dixie  logx, String thisDomainx, String tox,
                         String fromx, String letterx, String datax )
    {
        log        = logx;
        thisDomain = thisDomainx;
        to         = tox;
        from       = fromx;
        letter     = letterx;
        data       = datax; 

        Thread listener = new Thread( this );
        listener.start();
    }

    public void run()
    {
        StringBuffer newLetter = new StringBuffer();
        boolean inMessage = false;
        boolean wroteSubject = false;
        String subjectLine = "Subject: Forward";
        int inx;

        newLetter.append( "Received: By DixieMail Forwarding Extension (" +
                          to + ")" + cr );
        newLetter.append( "To: "+to+cr );
        newLetter.append( "From: "+from+cr );

        for ( inx = 0; inx < numberOfLines( letter ); inx++ )
        {
            String thisLine = getLine( letter, inx );

            if ( inMessage )
            {
                newLetter.append( thisLine+cr );
            }
            else if ( ( thisLine.startsWith( "To: " ) ) ||
                      ( thisLine.startsWith( "From: " ) ) )
            {
                newLetter.append( "Received: Originally " + thisLine + cr );
            }
            else
            {
                newLetter.append( thisLine+cr );
            }

            if ( thisLine.trim().length() == 0 )
            {
                inMessage = true;
            }
        }

        // Send but don't save dead letters or return to sender

        log.write( extensionName + ": to " + to );

        Forwarder forwarder = new Forwarder(
            thisDomain, data, from, newLetter.toString(), log,
            "Fwd to "+from, null, false );
    }
}


