import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 Simple class to start and control the mail (Smtp, Pop3, and Epass) servers.
 Comments:
 970915 Original code, lots of modifications
 971006 Added real top processing
 971027 More cleanup, focus on SMTP, forwarding
 98xxxx Made into windows driven stuff
 990110 Even more cleanup
 **/


/**
 * A form for obtaining user input. Customize this for your application, just
 * as you would customize an HTML form for a Web-based e-mail application.
 */


class InputDialog extends CFrame
{
    private dixie thisParent = null;
    private Extension extendParent = null;
    private String whyString;

    public InputDialog( dixie parent, String title, String why, String help )
    {
        setTitle( title );

        thisParent = parent;
        whyString  = why;
        add( new DialogForm( this, why, help ) );
        pack();
        center();
        show();
    }

    public InputDialog( Extension parent, String title, String why, String help )
    {
        setTitle( title );

        extendParent = parent;
        whyString  = why;
        add( new DialogForm( this, why, help ) );
        pack();
        center();
        show();
    }



    public void done( String value )
    {
        if ( thisParent != null )
        {
            thisParent.commandResponse( whyString, value );
        }
        else
        {
            extendParent.commandResponse( whyString, value );
        }

        this.dispose();
    }
}


class DialogForm extends Panel implements ActionListener
{
     private TextField toField;
     private Button searchButton;
     private InputDialog parentFrame;

 /**
  * The constructor
  */

    public DialogForm( InputDialog pf, String why, String help )
    {
        BorderLayout formbl;

        parentFrame = pf;
        setLayout( formbl = new BorderLayout() );

        formbl.setVgap( 2 );
        formbl.setHgap( 2 );

        // Instantiate all the elements, and add them to their containers...

        add( new Label( help ), "North" );
        add( searchButton = new Button( why ), "East" );
        add( toField      = new TextField(60), "Center" );

        searchButton.addActionListener( this );
    }

    public void actionPerformed(ActionEvent e)
    {
         parentFrame.done( toField.getText() );
    }
}
