import java.io.*;
import java.util.zip.*; // Used for CRC32


/**
 Structure to hold all mail.
 **/

public class Letters implements Runnable
{
    private String body;
    public Letters next;
    public String uid;
    public String to;
    private boolean markedForDelete;
    private static Letters allGroups = null;
    private static boolean loaded = false;
    private String mailFile = "mail";
    private static int numLetters = 0;
    private String cr = "\r\n";

    public void run()
    {
        StringBuffer allLetters = new StringBuffer();
        Letters temp         = allGroups;

        while ( temp != null )
        {
            allLetters.append( temp.to+"\n" );
            allLetters.append( temp.body+"\n.\n" );
            temp = temp.next;
        }

        try
        {
            Thread.sleep( 5000 ); // Wait 5 seconds

            try
            {
                FileWriter wout = new FileWriter( mailFile, false );
                wout.write( allLetters.toString() );
                wout.close();
            }
            catch ( Exception e2 )
            {
                e2.printStackTrace();
            }
        }
        catch ( java.lang.InterruptedException e )
        {
        }
    }

    public Letters()
    {
    }

    synchronized public void load()
    {
        String name;
        String text;
        StringBuffer message;
        BufferedReader win;

        try
        {
            win = new BufferedReader(new FileReader( mailFile ) );

            while ( win.ready() )
            {
                name = win.readLine();

                message = new StringBuffer();
                text = win.readLine();

                while ( !text.equals( "." ) )
                {
                    message.append( text+"\n" );

                    text = win.readLine();
                }

                add( name, message.toString() );
            }

            win.close();
        }
        catch ( Exception e ) /** File not found **/
        {
        }
    }

    synchronized public void save() // Start a save thread
    {
        Thread listener = new Thread(this);
        listener.setPriority(Thread.MIN_PRIORITY);
        listener.start();
    }

    synchronized public void add( String toField, String text )
    {
        Letters newLetter;
        Letters tempLetter;

        if ( ( toField != null ) && ( text != null ) )
        {
            newLetter      = new Letters();

            newLetter.to   = toField;
            newLetter.next = null;
            newLetter.body = fixBody( text, false );
            newLetter.markedForDelete = false;
            newLetter.uid  = getUid( newLetter.body );

            if ( allGroups == null ) // Add to start of list
            {
                allGroups = newLetter;
            }
            else // Add to end of list
            {
                tempLetter = allGroups;

                while ( tempLetter.next != null )
                {
                    tempLetter = tempLetter.next;
                }

                tempLetter.next = newLetter;
            }

            numLetters++;
        }

        save(); // Get ready to save
    }


    public String getUid( String y )
    {
        CRC32 xx = new CRC32();
        int x = 0;

        xx.reset();

        while ( x < y.length() )
        {
            xx.update( (int)y.charAt( x ) );
            x++;
        }

        return Long.toHexString( xx.getValue() ) +
               Integer.toHexString( y.hashCode() );
    }


    synchronized public void delete( String recipient )
    {
        Letters temp;
        Letters last;

        if ( allGroups != null )
        {
            if ( ( allGroups.to.toLowerCase().equals( recipient.toLowerCase() ) ) &&
                 ( allGroups.markedForDelete ) )
            {
                allGroups = allGroups.next;
                delete( recipient );
            }
            else
            {
                last = allGroups;
                temp = allGroups.next;

                while ( temp != null )
                {
                    if ( ( temp.to.toLowerCase().equals( recipient.toLowerCase() ) ) &&
                         ( temp.markedForDelete ) )
                    {
                        last.next = temp.next;
                        last = allGroups;
                        temp = allGroups.next;
                    }

                    last = temp;
                    temp = temp.next;
                }
            }
        }

        save(); // Get ready to save
    }

    synchronized public void markDelete()
    {
        markedForDelete = true;
    }

    synchronized public void unmarkDelete( String recipient )
    {
        Letters temp = first( recipient );

        while ( temp != null )
        {
            temp.markedForDelete = false;
            temp = temp.nextLetter( recipient );
        }
    }

    synchronized public Letters messageNumber( String recipient, int number )
    {
        int found         = 0;
        Letters temp      = first( recipient );
        Letters lastFound = null;

        while ( ( temp != null ) && ( found < number ) )
        {
            lastFound = temp;
            found++;
            temp = temp.nextLetter( recipient );
        }

        return lastFound;
    }

    synchronized public int number( String recipient )
    {
        int num      = 0;
        Letters temp = first( recipient );

        while ( temp != null )
        {
            num++;
            temp = temp.nextLetter( recipient );
        }

        return num;
    }

    synchronized public Letters nextLetter( String recipient )
    {
        Letters temp = this.next;

        while ( temp != null )
        {
            if ( temp.to.toLowerCase().equals( recipient.toLowerCase() ) )
            {
                return temp;
            }

            temp = temp.next;
        }

        return null;
    }

    synchronized public Letters first( String recipient )
    {
        Letters temp = new Letters();
        temp.next = allGroups;
        temp = temp.nextLetter( recipient );
        return temp;
    }

    /**
    Top returns the top n lines of a message's body.
    **/

    synchronized public String top( int nLines )
    {
        StringBuffer result = new StringBuffer();
        int inx       = 0;
        int lastChars = 0;
        int linesProcessed = 0;
        boolean inHeader = true;

        while ( ( inx < body.length() ) && inHeader )
        {
            if ( body.charAt( inx ) == '\n' )
            {
                if ( lastChars == 0 )
                {
                    inHeader = false;
                }
                else
                {
                    lastChars = 0;
                }
            }
            else
            {
                if ( body.charAt( inx ) != '\r' ) // Don't count returns
                {
                    lastChars++;
                }
            }

            result.append( body.charAt( inx ) );
            inx++;
        }

        while ( ( inx < body.length() ) && ( linesProcessed < nLines ) )
        {
            if ( body.charAt( inx ) == '\n' )
            {
                linesProcessed++;
            }

            result.append( body.charAt( inx ) );
            inx++;
        }

        return result.toString();
    }

    String getBody( boolean withCr )
    {
        return fixBody( body, withCr );
    }

    /**
    Returns body of message.  True parameter adds lf additions
    **/

    private String fixBody( String text, boolean withCr )
    {
        StringBuffer result = new StringBuffer();
        int          inx    = 0;

        while ( inx < text.length() ) 
        {
            if ( text.charAt( inx ) == '\n' )
            {
                if ( withCr )
                {
                    result.append( cr );
                }
                else
                {
                    result.append( "\n" );
                }
            }
            else
            {
                if ( text.charAt( inx ) != '\r' ) // Don't count returns
                {
                     result.append( text.charAt( inx ) );
                }
            }

            inx++;
        }

        return result.toString();
    }
}

