/**
Generic Server Class
 **/

import java.net.*;
import java.io.*;
import java.util.*;

class ServerKiller implements Runnable
{
    boolean stoppingOpenPorts = true;
    ThreadGroup tg;
    String serverName = "ServerKiller";
    String xDomain;
    int    xPort;
    Server xServer;
    String xName;

    public ServerKiller( Server serverToKill, String name,
                         String domain, int port )
    {
        Thread listener;
        xDomain = domain;
        xPort   = port;
        xServer = serverToKill;
        xName   = name;

        tg = new ThreadGroup( serverName );

        listener = new Thread( tg, this );
        listener.start();
    }

    public void run()
    {
        while ( stoppingOpenPorts )
        {
            try
            {
                Socket destinationSocket = new Socket(xDomain, xPort);
            }
            catch(Exception e)
            {
                stoppingOpenPorts = false;
            }
        }

        try
        {
            xServer.server.close();
        }
        catch( Exception e )
        {
            xServer.log.write( xName+": Could not close server" );
        }

        xServer.log.write( xName+": Stopped" );

        xServer.stopped  = true;
        xServer.stopping = false;
    }
}

/**
 Wrapper class for general text - type servers.  Includes socket
 timeouts, process stopping, etc.
**/

public class Server implements Runnable
{
    boolean      stopped     = true;
    boolean      stopping    = false;
    int          port        = 0;
    String       thisDomain  = "127.1.1.1";
    String       serverName  = "";
    ThreadGroup  tg;
    dixie        log;
    ServerSocket server;
    int          socketTimeout  = 120000; // Two minutes
    String       cr = "\r\n";

    static boolean monitorConnect = false;
    static boolean debug          = false;

    public void run() /** runServer must be overridden **/
    {
        Thread listener;
        Socket localSocket = null;

        try
        {
            localSocket = server.accept();

            /** Start a new server **/

            if ( !stopped && !stopping )
            {
                listener = new Thread( tg, this );
                listener.start();
            }

            runServer( localSocket );
        }
        catch(Exception e) // Socket exception is end of stream
        {  }

        /** Make sure the socket is closed nicely **/

        try
        {
           localSocket.close();
        }
        catch ( Exception e )
        {  }
    }

    public void runServer( Socket localSocket )
        throws java.io.IOException, java.net.SocketException
    {
    }

    public boolean setDebug( boolean newValue )
    {
        boolean oldValue = debug;
        debug = newValue;
        return oldValue;
    }

    public boolean setMonitorConnect( boolean newValue )
    {
        boolean oldValue = monitorConnect;
        monitorConnect = newValue;
        return oldValue;
    }

    public void sendAndDebug( PrintWriter to, String data )
    {
        to.print( data + cr );
        to.flush();
        debugLog( data );
    }

    public void debugLog( String debugString )
    {
        if ( debug )
        {
            log.write( serverName+": "+debugString );
        }
    }

    public void stopServer()
    {
        boolean stoppingOpenPorts = true;
        ServerKiller killer;

        if ( !stopped )
        {
            stopping = true;

            killer = new ServerKiller( this, serverName, thisDomain, port );

            // Killer sets stopped flag
        }
    }

    public void startServer()
    {
        if ( stopped )
        {
            Thread listener;

            try
            {
                server = new ServerSocket( port );
                log.write( serverName+": Started" );
            } catch(Exception e)
            {
                log.write(serverName+": Cannot create server socket");
            }

            tg = new ThreadGroup( serverName );
            stopped  = false;
            stopping = false;

            listener = new Thread( tg, this );
            listener.start();
        }
    }

    void saveUsers( Properties props )
    {
        StringTools.saveProps( props, "users", "User Information" );
    }

    Properties loadUsers()
    {
        return StringTools.loadProps( "users" );
    }

    Properties loadAutoReply()
    {
        return StringTools.loadProps( "autorepl" );
    }
}

