import java.net.*;
import java.io.*;
import java.util.*;
import java.lang.reflect.*;

/**
 Smtp mail server.
 **/

public class SmtpServer extends Server
{
    static int     maxMailServers = 10;        // Lots of mail servers
    Letters        letters;
    Config config;

    int getMaxMailServers()
    {
        return maxMailServers;
    }

    void setMaxMailServers( int newMax )
    {
        maxMailServers = newMax;
        log.write( serverName+": New maximum # mail servers: "+newMax );
    }

    public void runServer( Socket localSocket )
        throws java.io.IOException, java.net.SocketException
    {
        Properties users;
        BufferedReader from;
        PrintWriter to;
        String httpText;
        int inx;
        int iny;
        boolean loading;
        StringBuffer text;
        String command;
        String argument;
        boolean working = true;
        boolean localMail;
        boolean localServed; // Local mail to a served domain
        Forwarder forwarder;
        String thisServerName;
        String recipientName;
        String recipientDomain;
        String oneServedDomain;
        int numberOfRecipients = 0;
        int maxRecipients      = 30;
        String recipient[] = new String[maxRecipients];
        String returnTo        = "nobody";
        String portName;
        String okResponse;
        StringBuffer header;
        String headerAttach = " - "+config.versionString + " " +
               config.homepageString + cr;
        boolean extensionRun;

        from = new BufferedReader( new InputStreamReader( localSocket.getInputStream() ) );
        to   = new PrintWriter( new OutputStreamWriter( localSocket.getOutputStream() ), true );

        localSocket.setSoTimeout( socketTimeout );
        portName       = localSocket.getInetAddress().toString();
        thisServerName = localSocket.getInetAddress().getLocalHost().toString();
        header         = new StringBuffer( "Received: from " + thisServerName + 
                                           headerAttach );

        if ( monitorConnect )
        {
            log.write( serverName+": "+ portName+ " connected" );
        }
        else
        {
            debugLog( serverName + ": " + portName );
            debugLog( serverName + ": " + thisServerName );
        }

        if ( java.lang.Thread.activeCount() <= maxMailServers )
        {
            sendAndDebug( to, "220 Welcome!" );
        }
        else
        {
            sendAndDebug( to, "421 Too many connections - try later." );
            log.write( serverName+": "+ portName+ " too many connections" );
            working = false;
        }

        while ( working )
        {
            httpText = from.readLine();

            if ( httpText.length() == 0 ) /** Timeout **/
            {
                working = false;
            }

            command    = StringTools.firstWord( httpText ).toLowerCase();
            argument   = StringTools.notFirstWord( httpText ).toLowerCase();
            okResponse = "250 ok: " + httpText;

            if ( ( command.equals( "helo" ) ) ||
                 ( command.equals( "noop" ) ) )
            {
                sendAndDebug( to, okResponse );
            }
            else if ( command.equals( "rset" ) )
            {
                sendAndDebug( to, okResponse );
                numberOfRecipients = 0;
            }
            else if ( command.equals( "quit" ) )
            {
                sendAndDebug( to, "221 ok, later dude: "+ httpText );
                working = false;
            }
            else if ( command.equals( "mail" ) )
            {
                sendAndDebug( to, okResponse );
                returnTo = smtp.wholeUser( argument );
            }
            else if ( command.equals( "rcpt" ) )
            {
                sendAndDebug( to, okResponse );

                if ( numberOfRecipients < maxRecipients )
                {
                    recipient[numberOfRecipients] = smtp.wholeUser( httpText );
                    numberOfRecipients++;
                }
            }
            else if ( command.equals( "data" ) )
            {
                sendAndDebug( to, "354 Enter your mail." );
                loading = true;
                text = new StringBuffer();

                // Get the mail

                while ( loading )
                {
                    httpText = from.readLine();

                    if ( httpText.equals( "." ) )
                    {
                        loading = false;
                    }
                    else
                    {
                        text.append( httpText+cr );
                    }
                }

                sendAndDebug( to, okResponse );

                text.insert( 0, header.toString() );

                // Deliver the mail

                for ( inx = 0; inx < numberOfRecipients; inx++ )
                {
                    recipientName   = smtp.user( recipient[inx] );
                    recipientDomain = smtp.domain( recipient[inx] );
                    localMail       = false;
                    localServed     = false;

                    if ( thisDomain.toLowerCase().startsWith( recipientDomain.toLowerCase() ) )
                    {
                        localMail = true; // Local mail to this server
                    }

                    for ( iny = 0; iny <= StringTools.findCommas( config.ServedDomains ); iny++ )
                    {
                        oneServedDomain = StringTools.commaParser( config.ServedDomains, iny ).toLowerCase();

                        if ( ( recipientDomain.toLowerCase().equals( oneServedDomain ) ) &&
                             ( !config.ServedDomains.equals( log.getNullProperty() ) ) )
                        {
                            localMail   = true;
                            localServed = true;
                            break;
                        }
                    }

                    if ( localMail )
                    {
                        // Code to go through extensions

                        String extension;
                        BufferedReader win;
                        extensionRun = false;

                        try
                        {
                            win = new BufferedReader(new FileReader( "extend" ) );

                            while ( win.ready() )
                            {
                                extension = win.readLine();

                                if ( ( recipientName.equals( StringTools.commaParser( extension, 0 ) ) ) ||
                                     ( recipient[inx].equals( StringTools.commaParser( extension, 0 ) ) ) ) // Served
                                {
                                    Class[] parmClass = new Class[1];
                                    parmClass[0] = log.getClass();

                                    Constructor xclass = java.lang.Class.forName(
                                        StringTools.commaParser( extension, 1 ) ).getConstructor(parmClass);
                                    Object temp[] = { log };
                                    Extension runFunct = (Extension)( xclass.newInstance( temp ) );

                                    runFunct.execute( log, thisDomain, StringTools.commaParser( extension, 0 ), returnTo,
                                                      text.toString(), StringTools.commaParser( extension, 2 ) );
                                    extensionRun = true;
                                }
                            }

                            win.close();
                        }
                        catch ( Exception e ) /** File not found **/
                        { }

                        if ( !extensionRun ) // Normal mail received
                        {
                            if ( !localServed )
                            {
                                letters.add( recipientName, text.toString() );
                            }
                            else
                            {
                                letters.add( recipient[inx], text.toString() );
                            }

                            letters.save();
                        }
                    }
                    else //Forward to some other mail server
                    {
                        debugLog(serverName + ": Forwarding to "+config.OutgoingServer );
                        forwarder = new Forwarder( config.OutgoingServer, recipient[inx],
                            returnTo, text.toString(), log,
                            "Outbound to "+recipientDomain, letters, true );
                    }

                    text = new StringBuffer();
                } // For all recipients
            } // If data
            else if ( StringTools.firstWord( httpText ).equals( "" ) )
            {   }
            else
            {
                debugLog(serverName+": !"+portName+": "+httpText );
                sendAndDebug( to, "502 Command not implemented" );
            }
        }
    }

    public SmtpServer( Letters lettersx, dixie logx )
    {
        letters       = lettersx;
        log           = logx;
        port          = 25;
        serverName    = "Smtp";
        config        = logx.configuration;

        startServer();
    }
}


