/**
StringTools - Generic String tools
 **/

import java.net.*;
import java.io.*;
import java.util.*;


public class StringTools
{
    static String       cr = "\r\n";

    static String firstWord( String text )
    {
        StringBuffer word = new StringBuffer();
        int pos = 0;

        while ( ( text.length() > pos ) && ( text.charAt(pos) != ' ' ) )
        {
            word.append( text.charAt(pos) );
            pos++;
        }

        return word.toString();
    }

    static String notFirstWord( String text )
    {
        StringBuffer word = new StringBuffer();
        int pos = 0;

        while ( ( text.length() > pos ) && ( text.charAt(pos) != ' ' ) )
        {
            pos++;
        }

        while ( ( text.length() > pos ) && ( text.charAt(pos) == ' ' ) )
        {
            pos++;
        }

        while ( text.length() > pos )
        {
            word.append( text.charAt(pos) );
            pos++;
        }

        return word.toString();
    }

    static void saveProps( Properties props, String filename, String text )
    {
        try
        {
            try
            {
                File wFile = new File( filename );
                FileOutputStream fos = new FileOutputStream( wFile );
                props.save( fos, text );
                fos.close();
            }
            catch ( FileNotFoundException e )
            {  }
        }
        catch ( IOException e )
        {  }
    }


    static Properties loadProps( String propname )
    {
        Properties temp = new Properties();

        try
        {
            try
            {
                File readFile = new File( propname );
                FileInputStream fis = new FileInputStream( readFile );
                temp.load( fis );
                fis.close();
            }
            catch ( FileNotFoundException e )
            {  }
        }
        catch ( IOException e )
        {  }

        return temp;
    }

    static synchronized void saveFile( String filename, String data )
    {
        BufferedWriter out;

        try
        {
            out = new BufferedWriter( new FileWriter( filename ) );
            out.write( data, 0, data.length() );
            out.close();
        }
        catch ( Exception e ) /** Could not write file **/
        { }
    }


    static synchronized String getFile( String fileName )
    {
        String text;
        StringBuffer message = new StringBuffer();
        BufferedReader win;

        try
        {
            win = new BufferedReader(new FileReader( fileName ) );

            while ( win.ready() )
            {
                text = win.readLine();
                message.append( text+cr );
            }

            win.close();
        }
        catch ( Exception e ) /** File not found **/
        {
        }

        return message.toString();
    }


    static int findCommas( String item )
    {
         int inx;
         int retval = 0;

         for ( inx = 0; inx < item.length(); inx++ )
         {
             if ( item.charAt(inx) == ',' )
             {
                 retval++;
             }
         }

         return retval;
     }

     static String commaParser( String item, int position )
     {
         int commasParsed;
         int inx = 0;
         int iny = 0;

         /** Skip commas **/

         for ( commasParsed = 0; position > commasParsed; commasParsed++ )
         {
             inx = item.indexOf( ',', inx ) + 1;
         }

         iny = item.indexOf( ',', inx );

         if ( iny == -1 ) // Last item
         {
             iny = item.length();
         }

         return item.substring( inx, iny );
     }
}

