import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.lang.reflect.*;
import StringTools;

/**
 Simple class to start and control the mail (Smtp, Pop3, and Epass) servers.
 Comments:
 970915 Original code, lots of modifications
 971006 Added real top processing
 971027 More cleanup, focus on SMTP, forwarding
 98xxxx Made into windows driven stuff
 990110 Even more cleanup
 990326 Split into separate files
 **/


/**
 * Create a frame that can be closed; only used if run standalone.
 */

class dixie extends CFrame implements ActionListener, ItemListener
{
    private MenuBar menu;
    private Letters letters;
    private SmtpServer mailTask;
    private Pop3Server popTask;
    private EpassServer passTask;
    private FileWriter wout;
    private boolean debugDixie = true;
    private MainDialog f;
    private Properties dixieProps;
    private CheckboxMenuItem debugBox;
    private CheckboxMenuItem monitorBox;
    private CheckboxMenuItem showStatusBox;

    private String dixiePropsString          = "DixieMail.cfg";
    private String versionString             = "DixieMail v1.6";
    private String authorString              = "James Ghofulpo";
    private String homepageString            = "http://welcome.to/reality";

    private String monitorProp               = "monitorString";
    private String usersProp                 = "usersString";
    private String debugProp                 = "debugString";
    private String monitorConnectProp        = "monitorConnect";
    private String listUsersProp             = "listUsers";
    private String addUsersProp              = "addUsers";
    private String deleteUsersProp           = "deleteUser";
    private String clearLogProp              = "clearLog";
    private String extensionsProp            = "extensions";
    private String passEnterUserProp         = "enterUser";
    private String passNewPasswordProp       = "newPassword";
    private String passEnterUserHelpProp     = "enterUserHelp";
    private String passNewPasswordHelpProp   = "newPasswordHelp";
    private String changeOutgoingSmtpProp    = "changeOutgoingSmtp";
    private String optionsProp               = "options";
    private String showSplashScreenProp      = "showSplash";
    private String showSettingsProp          = "showSettings";
    private String changeServedProp          = "changeServed";
    private String changeServedHelpProp      = "changeServedHelp";
    private String displayStatusProp         = "displayStatus";
    private String hideMainWindowProp        = "hideMainWindow";
    private String lastValue    = "none";
    private String nullProperty = "<none>";
    private String generalHelpProp           = "generalHelp";
    private String extensionListProp         = "extensionList";

    private String outgoingName          = "outgoing";
    private String servedDomainsName     = "served";
    private String usersFileName         = "users";
    private String usersFileDescription  = "Users Information";
    private String configFileDescription = "DixieMail Configuration";

    public Config configuration;

    String getNullProperty()
    {
        return nullProperty;
    }

    String getString( String propname )
    {
        return dixieProps.getProperty( propname, propname );
    }


    /*****************************************************************

    Responses to commands

    *****************************************************************/
  
    public void commandResponse( String why, String value )
    {
        write( why+" "+value );

        if ( why.equals( getString( deleteUsersProp ) ) )
        {
            Properties props = StringTools.loadProps( usersFileName );
            props.remove( value );
            StringTools.saveProps( props, usersFileName, usersFileDescription );
        }
        else if ( why.equals( getString( passEnterUserProp ) ) )
        {
            new InputDialog( this,
                             getString( passEnterUserProp ),
                             getString( passNewPasswordProp ),
                             getString( passNewPasswordHelpProp ) );
        }
        else if ( why.equals( getString( passNewPasswordProp ) ) )
        {
            Properties props = StringTools.loadProps( usersFileName );
            props.remove( lastValue );
            props.put( lastValue, value );
            StringTools.saveProps( props, usersFileName, usersFileDescription );
        }
        else if ( why.equals( getString( changeOutgoingSmtpProp ) ) )
        {
            if ( value.length() == 0 )
            {
                value = nullProperty;
            }

            configuration.OutgoingServer = value;
            dixieProps.put( outgoingName, value );
        }
        else if ( why.equals( getString( changeServedProp ) ) )
        {
            if ( value.length() == 0 )
            {
                value = nullProperty;
            }

            configuration.ServedDomains = value;
            dixieProps.put( servedDomainsName, value );
        }

        lastValue = value;

        StringTools.saveProps( dixieProps, dixiePropsString,
                               configFileDescription );
    }

    public void actionPerformed(ActionEvent e)
    {
        OutputDialog od;
        String command = e.getActionCommand();
        int inx;
        InetAddress here;
        String tempString;

        if ( command.equals( getString( listUsersProp ) ) )
        {
            Properties h = StringTools.loadProps( usersFileName );

            od = new OutputDialog( getString( listUsersProp ) );

            for (Enumeration en = h.keys() ; en.hasMoreElements() ;) 
            {
	          String key = (String)en.nextElement();
	          String val = (String)h.get(key);
                  od.append( key );
            }
        }
        else if ( command.equals( getString( clearLogProp ) ) )
        {
            f.clearLog();
        }
        else if ( command.equals( getString( addUsersProp ) ) )
        {
            new InputDialog( this, getString( addUsersProp ),
                                   getString( passEnterUserProp ),
                                   getString( passEnterUserHelpProp ) );
        }
        else if ( ( command.equals( getString( deleteUsersProp ) ) )         ||
                  ( command.equals( getString( changeOutgoingSmtpProp ) ) ) )
        {
            new InputDialog( this, getString( command ),
                                   getString( command ),
                                   getString( generalHelpProp ) );
        }
        else if ( ( command.equals( getString( changeServedProp ) ) ) )
        {
            new InputDialog( this, getString( command ),
                                   getString( command ),
                                   getString( changeServedHelpProp ) );
        }
        else if ( command.equals( getString( showSplashScreenProp ) ) )
        {
            new Splash();
        }
        else if ( command.equals( getString( showSettingsProp ) ) )
        {
            od = new OutputDialog( command );
            inx = 0;

            od.append( "Version: "+versionString );
            od.append( "Author: "+authorString );
            od.append( "DixieMail Homepage: "+homepageString );

            try
            {
                here = InetAddress.getLocalHost();
                od.append( "Location: "+ here.getHostAddress() );
                od.append( "Name: "+here.getHostName() );

                try
                {
                    while ( true ) // Parse whole array
                    {
                        od.append( "    a.k.a.: "+
                                   InetAddress.getAllByName( here.getHostAddress() )[inx++]);
                    }
                }
                catch ( java.lang.ArrayIndexOutOfBoundsException arrayex )
                { }
            }
            catch ( java.net.UnknownHostException uh )
            {
                od.append( "Note: Could not get local host information" );
            }

            od.append( "Outgoing SMTP: "+configuration.OutgoingServer );
            od.append( "SMTP Max Servers: "+mailTask.getMaxMailServers() );
            od.append( "SMTP Served Domains: "+configuration.ServedDomains );
        }
        else if ( command.equals( getString( hideMainWindowProp ) ) )
        {
            this.setVisible( false );
        }

        StringTools.saveProps( dixieProps, dixiePropsString, configFileDescription );
    }

    public void itemStateChanged( ItemEvent e )
    {
        String command = (String)e.getItem();
        boolean state = true;

        if ( command.equals( getString( debugProp ) ) )
        {
            state = debugBox.getState();

            mailTask.setDebug( state );
            popTask.setDebug( state );
            passTask.setDebug( state );
        }
        else if ( command.equals( getString( monitorConnectProp ) ) )
        {
            state = monitorBox.getState();

            mailTask.setMonitorConnect( state );
            popTask.setMonitorConnect( state );
            passTask.setMonitorConnect( state );
        }
        else if ( command.equals( getString( displayStatusProp ) ) )
        {
            state = showStatusBox.getState();
            f.showStatus( state );
        }
    }

    public Letters getLetters()
    {
        return letters;
    }

    public static void main( String argv[] )
    {
        new dixie();
    }


    // Main function

    public dixie()
    {
        Menu   subMenu;
        CheckboxMenuItem cbox;
        String tempProperty;
        String extension;
        int    inx;

        configuration = new Config();
        dixieProps    = StringTools.loadProps( dixiePropsString );

        setTitle( versionString );
        setIconImage( Toolkit.getDefaultToolkit().getImage( setup.getIcon() ) );
        addWindowListener( this );

        // Create the menu bar

        menu = new MenuBar();

        subMenu = new Menu( getString( monitorProp ) );
        subMenu.add( getString( clearLogProp ) );
        debugBox = new CheckboxMenuItem( getString( debugProp ) );
        debugBox.addItemListener( this );
        subMenu.add( debugBox );
        monitorBox = new CheckboxMenuItem( getString( monitorConnectProp ) );
        monitorBox.addItemListener( this );
        subMenu.add( monitorBox );
        subMenu.addActionListener( this );
        menu.add( subMenu );

        subMenu = new Menu( getString( usersProp ) );      
        subMenu.add( getString( listUsersProp ) );
        subMenu.add( getString( addUsersProp ) );
        subMenu.add( getString( deleteUsersProp ) );
        subMenu.addActionListener( this );
        menu.add( subMenu );

        subMenu = new Menu( getString( extensionsProp ) );
        subMenu.addActionListener( this );

        for ( inx = 0; inx <= StringTools.findCommas( getString( extensionListProp ) ); inx++ )
        {
            try
            {
                extension = StringTools.commaParser( getString( extensionListProp), inx );

                Class[] parmClass = new Class[1];
                parmClass[0] = this.getClass();

                Constructor xclass = java.lang.Class.forName( extension ).getConstructor(parmClass);
                Object temp[] = { this };
                Extension runFunct = (Extension)( xclass.newInstance( temp ) );
                subMenu.add( runFunct.getMenu() );
            }
            catch ( Exception ex )
            { }
        }

        menu.add( subMenu );

        subMenu = new Menu( getString( optionsProp ) );
        subMenu.add( getString( showSettingsProp ) );
        subMenu.add( getString( changeOutgoingSmtpProp ) );
        subMenu.add( getString( changeServedProp ) );
        subMenu.add( getString( showSplashScreenProp ) );
        showStatusBox = new CheckboxMenuItem( getString( displayStatusProp ) );
        showStatusBox.addItemListener( this );
        subMenu.add( showStatusBox );
        subMenu.add( getString( hideMainWindowProp ) );
        subMenu.addActionListener( this );
        menu.add( subMenu );
        this.setMenuBar( menu );

        showStatusBox.setState( true );

        f = new MainDialog();

        new Splash();

        add( f );
        pack();
        center();
        show();

        letters = new Letters();
        letters.load();

        try
        {
            wout = new FileWriter( "mail.log", false );
        }
        catch( java.io.IOException e )
        {
            write("Could not open log file");
        }

        f.append( versionString + " - " + authorString + " - " +
                  homepageString );

        /** Set user defined variables **/

        configuration.OutgoingServer = dixieProps.getProperty( outgoingName, nullProperty );
        configuration.ServedDomains  = dixieProps.getProperty( servedDomainsName, nullProperty );
        configuration.versionString  = versionString;
        configuration.homepageString = homepageString;

        /** Start the servers **/

        mailTask = new SmtpServer( letters, this );
        popTask  = new Pop3Server( letters, this );
        passTask = new EpassServer( this );
    }

    /**
     Writes data to the mail.log file
     **/

    public void write( String data )
    {
        if ( debugDixie )
        {
            f.append( (new Date()).toString() + " " + data );
        }

        try
        {
            wout.write( (new Date()).toString() + " " + data + "\n" );
            wout.flush();
        }
        catch( java.io.IOException e )
        {
            f.append( (new Date()).toString() +
                      " Could not write to log file" );
        }
    }

    /**
     Starts the Smtp, Pop3, and Password Servers.
     Note that servers generally start automatically when created, so
     the constructor should take care of this the first time.
     **/

    public void start()
    {
        mailTask.startServer();
        popTask.startServer();
        passTask.startServer();
    }

    /**
     Stops the Smtp, Pop3, and Password Servers
     **/

    public void stop()
    {
        write( "Stopping DixieMail Server..." );
        mailTask.stopServer();
        popTask.stopServer();
        passTask.stopServer();

        while ( !mailTask.stopped ||
                !popTask.stopped ||
                !passTask.stopped )
        {
            try
            {
                Thread.sleep( 100 );
            }
            catch ( java.lang.InterruptedException e )
            {
            }
        }
    }

    public void windowClosing( WindowEvent e )
    {
        stop();
        this.setVisible( false );
        System.exit(0);
    }
}



