/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class WWWServer
extends Server {
    static final String serverType = "DixieMail";
    static final String zipFileName = "data.zip";
    static final String thisHost = "127.0.0.1";
    static final String mainPage = "/index.html";
    static final String loginPage = "/login.html";
    static final String standardHeader = "/stdhdr.html";
    static final String standardEnding = "/stdend.html";
    static final String mailHome = "/mail";
    static final String adminHome = "/admin";
    static final String statusHome = "/status";

    public String getHostName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = thisHost;
        }
        return string;
    }

    void transmit(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes(), 0, string.length());
    }

    void zipLocateFile(ZipInputStream zipInputStream, String string) throws FileNotFoundException {
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (string.toLowerCase().compareTo("/" + zipEntry.getName().toLowerCase()) != 0) {
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            return;
        }
        catch (Exception exception) {
            throw new FileNotFoundException();
        }
    }

    void sendHeader(OutputStream outputStream) throws IOException {
        this.transmit(outputStream, "HTTP/1.0 200 OK\n");
        this.transmit(outputStream, "Server: DixieMail\n");
        this.transmit(outputStream, "\n");
    }

    void sendZipFile(OutputStream outputStream, String string) throws FileNotFoundException {
        int n = 8000;
        int n2 = 0;
        File file = new File(zipFileName);
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        try {
            int n3;
            this.zipLocateFile(zipInputStream, string);
            byte[] byArray = new byte[n];
            do {
                if ((n3 = zipInputStream.read(byArray, 0, n)) == -1) continue;
                outputStream.write(byArray, 0, n);
                n2 += n3;
            } while (n3 != -1);
            fileInputStream.close();
            zipInputStream.closeEntry();
            zipInputStream.close();
            return;
        }
        catch (Exception exception) {
            throw new FileNotFoundException();
        }
    }

    void sendFile(OutputStream outputStream, String string) {
        try {
            this.sendZipFile(outputStream, string);
            return;
        }
        catch (Exception exception) {
            try {
                this.sendZipFile(outputStream, mainPage);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return;
            }
        }
    }

    public void runServer(Socket socket) throws IOException, SocketException {
        String string;
        String string2 = "";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream()), true);
        OutputStream outputStream = socket.getOutputStream();
        socket.setSoTimeout(this.socketTimeout);
        if (Server.monitorConnect) {
            this.log.write(String.valueOf(this.serverName) + ": " + socket.getInetAddress().toString() + " connected");
        }
        do {
            if ((string = bufferedReader.readLine()).startsWith("GET")) {
                string2 = StringTools.firstWord(StringTools.notFirstWord(string));
            }
            if (!Server.debug) continue;
            this.log.write(String.valueOf(this.serverName) + ": " + string);
        } while (string.length() != 0);
        this.log.write(String.valueOf(this.serverName) + ": " + string2);
        this.sendHeader(outputStream);
        if (string2.startsWith(mailHome)) {
            WWWMail.handleMail(this, string2, printWriter, outputStream, mailHome);
            return;
        }
        if (string2.startsWith(adminHome)) {
            WWWAdmin.handleAdmin(this, string2, printWriter, outputStream, adminHome);
            return;
        }
        if (string2.startsWith(statusHome)) {
            WWWStatus.showStatus(this, string2, printWriter, outputStream, statusHome);
            return;
        }
        this.sendFile(outputStream, string2);
    }

    public WWWServer(dixie dixie2) {
        this.log = dixie2;
        this.port = 80;
        this.serverName = "WWW";
        this.startServer();
    }
}

