import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class CFrame extends Frame implements WindowListener
{
    public CFrame()
    {
        super();

        setIconImage( Toolkit.getDefaultToolkit().getImage( "dixie.gif" ) );
        this.addWindowListener( this );
    }

    public CFrame( String iconName )
    {
        super();

        setIconImage( Toolkit.getDefaultToolkit().getImage( iconName ) );
        this.addWindowListener( this );
    }

    public void center()
    {
        Dimension screenDim;
        Dimension splashDim;
        int hpos;
        int wpos;

        splashDim = this.getSize();
        screenDim = this.getToolkit().getScreenSize();

        hpos = ( screenDim.height - splashDim.height ) / 2;
        wpos = ( screenDim.width - splashDim.width ) / 2;

        this.setLocation( wpos, hpos );
    }

    public void windowOpened( WindowEvent e ) { }
    public void windowClosed( WindowEvent e ) { }
    public void windowIconified( WindowEvent e ) { }
    public void windowDeiconified( WindowEvent e ) { }
    public void windowActivated( WindowEvent e ) { }
    public void windowDeactivated( WindowEvent e ) { }
    public void windowClosing( WindowEvent e )
    {
        this.setVisible( false );
        this.dispose();
    }
}
