import java.awt.*;
import java.util.*;

public class CWindow extends Window
{
    CWindow( Frame x, String iconName )
    {
        super( x );

        x.setIconImage( Toolkit.getDefaultToolkit().getImage( iconName ) );
    }

    public void center()
    {
        Dimension screenDim;
        Dimension splashDim;
        int hpos;
        int wpos;

        splashDim = this.getSize();
        screenDim = this.getToolkit().getScreenSize();

        hpos = ( screenDim.height - splashDim.height ) / 2;
        wpos = ( screenDim.width - splashDim.width ) / 2;


        this.setLocation( wpos, hpos );
    }
}
