import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 Mail Forwarder Server
 **/

public class Fwd extends Extension implements Runnable
{
    String lastValue;

    public Fwd( dixie logx )
    {
        log           = logx;
        extensionName = "Fwd";
    }

    public void execute( dixie  logx, String thisDomainx, String tox,
                         String fromx, String letterx, String datax )
    {
        log        = logx;
        thisDomain = thisDomainx;
        to         = tox;
        from       = fromx;
        letter     = letterx;
        data       = datax; 

        Thread listener = new Thread( this );
        listener.start();
    }

    public void run()
    {
        StringBuffer newLetter = new StringBuffer();
        boolean inMessage = false;
        boolean wroteSubject = false;
        String subjectLine = "Subject: Forward";
        int inx;

        newLetter.append( "Received: By DixieMail Forwarding Extension (" +
                          to + ")" + cr );
        newLetter.append( "To: "+to+cr );
        newLetter.append( "From: "+from+cr );

        for ( inx = 0; inx < numberOfLines( letter ); inx++ )
        {
            String thisLine = getLine( letter, inx );

            if ( inMessage )
            {
                newLetter.append( thisLine+cr );
            }
            else if ( ( thisLine.startsWith( "To: " ) ) ||
                      ( thisLine.startsWith( "From: " ) ) )
            {
                newLetter.append( "Received: Originally " + thisLine + cr );
            }
            else
            {
                newLetter.append( thisLine+cr );
            }

            if ( thisLine.trim().length() == 0 )
            {
                inMessage = true;
            }
        }

        // Send but don't save dead letters or return to sender

        log.write( extensionName + ": to " + to );

        Forwarder forwarder = new Forwarder(
            thisDomain, data, from, newLetter.toString(), log,
            "Fwd to "+from, null, false );
    }
}


