import java.io.*;
import java.awt.*;

/**
 Listserv server
 **/

public class Listserv extends Extension implements Runnable
{
    dixie  log;
    String thisDomain;
    String to;
    String from;
    String letter;
    String data;
    String fwdExtension = "ListFwd";
    private String listservHeader = "extension.listserv.";

    public Listserv( dixie logx )
    {
        log = logx;
    }

    public void execute( dixie  logx, String thisDomainx, String tox,
                         String fromx, String letterx, String datax )
    {
        log        = logx;
        thisDomain = thisDomainx;
        to         = tox;
        from       = fromx;
        letter     = letterx;
        data       = datax;

        Thread listener = new Thread( this );
        listener.start();
    }

    public void run()
    {
        int inx;
        int iny;
        StringBuffer newLetter = new StringBuffer();
        String thisLine;
        String listservData;
        //String extendData;
        String lData;
        String welcomeData;
        boolean subscribed = false;
        boolean authorized = false;
        StringBuffer newData  = null;
        StringBuffer newData2 = null;
        Forwarder forwarder;

        newLetter.insert( 0, "To: "+from+cr );
        newLetter.insert( 0, "From: "+to+cr );
        newLetter.append( "Subject: Listserv Results (Auto Response)"+cr+cr );

        try
        {
            for ( inx = 0; inx < numberOfLines( letter ); inx++ )
            {
                listservData = StringTools.getFile( "listserv" );
                //extendData = StringTools.getFile( "extend" );
                thisLine = getLine( letter, inx );

                if ( thisLine.startsWith("help" ) )
                {
                    newLetter.append( StringTools.getFile( "listserv.hlp" ) );
                }
                else if ( thisLine.startsWith("user" ) )
                {
                    if ( StringTools.findCommas( argument( thisLine ) ) == 1 )
                    {
                        authorized = log.validUser(
                            StringTools.commaParser( argument( thisLine ), 0 ),
                            StringTools.commaParser( argument( thisLine ), 1 ) );
                    }

                    newLetter.append( ">"+argument( thisLine ) +"<"+cr );
                    if ( authorized )
                    {
                        newLetter.append( "Authorization accepted"+cr );
                    }
                    else
                    {
                        newLetter.append( "Authorization denied!"+cr );
                        newLetter.append( "Remainder of letter will be ignored."+cr );
                        inx = numberOfLines( letter );
                    }
                }
                else if ( thisLine.startsWith("subscribe") )
                {
                    newLetter.append( ">" + getLine( letter, inx ) + cr );

                    if ( true ) //inFile( "extend", argument( thisLine ) ) )
                    {
                        newLetter.append( "You are now subscribed to "+argument( thisLine )+ cr );
                        newData = new StringBuffer( listservData );
                        newData.append( argument( thisLine )+" "+from+cr );
                        StringTools.saveFile( "listserv", newData.toString() );

                        welcomeData = StringTools.getFile( "subscrib.txt" );

                        if ( welcomeData.length() > 0 )
                        {
                            // Send, do not save dead letters or return to sender
                            forwarder = new Forwarder(
                                thisDomain, from, to, welcomeData, log,
                                "Listserv to "+from+"(welcome)", null, false );
                        }
                    }
                    else
                    {
                        newLetter.append( "Could not subscribe you to "+argument( thisLine )+": no such group."+cr );
                    }
                }
                else if ( thisLine.startsWith("unsubscribe") )
                {
                    newLetter.append( ">" + getLine( letter, inx ) + cr );

                    //subscribed = removeFrom( "listserv", argument( thisLine ) );

                    if ( subscribed )
                    {
                        newLetter.append( "You are now unsubscribed from "+argument( thisLine )+ cr );
                    }
                    else
                    {
                        newLetter.append( "Could not unsubscribe you from "+argument( thisLine )+": no such group."+cr );
                    }
                }
                else if ( thisLine.startsWith("create") )
                {
                    if ( authorized )
                    {
                        subscribed = false;
                        newLetter.append( ">" + getLine( letter, inx ) + cr );

                        if ( !( log.getPassword( argument( thisLine ) ).equals(
                                User.invalidPassword ) ) )
                        {
                            newLetter.append( "Could not create "+argument( thisLine )+
                                              ": Already exists in users."+cr );
                            subscribed = true;
                        }

                        if ( !subscribed )
                        {
                            addExtension( argument( thisLine ).trim(), fwdExtension,
                                          argument( thisLine )+cr );

                            //newData = new StringBuffer( extendData );
                            //newData.append( argument( thisLine ).trim()+"," + fwdExtension +
                            //                ","+argument( thisLine )+cr );
                            //StringTools.saveFile( "extend", newData.toString() );

                            // ********** need to fix this stuff

                            //newData = new StringBuffer( userData );
                            //newData.append( argument(thisLine)+"=dead\n" );
                            //StringTools.saveFile( "users", newData.toString() );

                            newLetter.append( "Created "+argument( thisLine )+cr );
                        }
                        else
                        {
                            newLetter.append( "Could not create "+argument( thisLine )+": Already exists."+cr );
                        }
                    }
                    else
                    {
                        newLetter.append( "Sorry, need authorization."+cr );
                    }
                }
                else if ( thisLine.startsWith( "remove" ) )
                {
                    if ( authorized )
                    {
                        newLetter.append( ">" + getLine( letter, inx ) + cr );

                        //subscribed = removeFrom( "extend", argument( thisLine ) );

                        if ( subscribed )
                        {
                            //removeFrom( "listserv", argument( thisLine ) );
                            //removeFrom( "users", argument( thisLine ) );
                            newLetter.append( "Removed "+argument( thisLine )+cr );
                        }
                        else
                        {
                            newLetter.append( "Could not remove "+argument( thisLine )+"."+cr );
                        }
                    }
                    else
                    {
                        newLetter.append( "Sorry, need authorization."+cr );
                    }
                }
            }
        }
        catch ( Exception e ) { }

        // Send, do not save dead letters or attempt return to sender

        forwarder = new Forwarder(
            thisDomain, from, to, newLetter.toString(), log,
            "Listserv to "+from, null, false );
    }
}


