/**
StringTools - Generic String tools
 **/

import java.net.*;
import java.io.*;
import java.util.*;


public class StringTools
{
    static String       cr = "\r\n";

    static String firstWord( String text )
    {
        StringBuffer word = new StringBuffer();
        int pos = 0;

        while ( ( text.length() > pos ) && ( text.charAt(pos) != ' ' ) )
        {
            word.append( text.charAt(pos) );
            pos++;
        }

        return word.toString();
    }

    static String notFirstWord( String text )
    {
        StringBuffer word = new StringBuffer();
        int pos = 0;

        while ( ( text.length() > pos ) && ( text.charAt(pos) != ' ' ) )
        {
            pos++;
        }

        while ( ( text.length() > pos ) && ( text.charAt(pos) == ' ' ) )
        {
            pos++;
        }

        while ( text.length() > pos )
        {
            word.append( text.charAt(pos) );
            pos++;
        }

        return word.toString();
    }

    static void saveProps( Properties props, String filename, String text )
    {
        try
        {
            try
            {
                File wFile = new File( filename );
                FileOutputStream fos = new FileOutputStream( wFile );
                props.save( fos, text );
                fos.close();
            }
            catch ( FileNotFoundException e )
            {  }
        }
        catch ( IOException e )
        {  }
    }


    static Properties loadProps( String propname )
    {
        Properties temp = new Properties();

        try
        {
            try
            {
                File readFile = new File( propname );
                FileInputStream fis = new FileInputStream( readFile );
                temp.load( fis );
                fis.close();
            }
            catch ( FileNotFoundException e )
            {  }
        }
        catch ( IOException e )
        {  }

        return temp;
    }

    static synchronized void saveFile( String filename, String data )
    {
        BufferedWriter out;

        try
        {
            out = new BufferedWriter( new FileWriter( filename ) );
            out.write( data, 0, data.length() );
            out.close();
        }
        catch ( Exception e ) /** Could not write file **/
        { }
    }


    static synchronized String getFile( String fileName )
    {
        String text;
        StringBuffer message = new StringBuffer();
        BufferedReader win;

        try
        {
            win = new BufferedReader(new FileReader( fileName ) );

            while ( win.ready() )
            {
                text = win.readLine();
                message.append( text+cr );
            }

            win.close();
        }
        catch ( Exception e ) /** File not found **/
        {
        }

        return message.toString();
    }


    static void sendBinaryFile( PrintWriter to, String fileName )
    {
        BufferedInputStream win;
        int count = 0;
        char temp [] = new char[1];

        try
        {
            win = new BufferedInputStream(new FileInputStream( fileName ) );

            while ( win.available() != 0 )
            {
                temp[0] = (char) win.read();
                to.write( temp );
                count++;
            }
        }
        catch ( Exception e ) /** File not found or end of file **/
        {
        }

        to.flush();

        System.out.println("Sent "+count );
    }


    static int findChar( String item, char charToLocate )
    {
         int inx;
         int retval = 0;

         for ( inx = 0; inx < item.length(); inx++ )
         {
             if ( item.charAt(inx) == charToLocate )
             {
                 retval++;
             }
         }

         return retval;
     }

     static String charParser( char separator, String item, int position )
     {
         int separatorsParsed;
         int inx = 0;
         int iny = 0;

         /** Skip separators **/

         try
         {
             for ( separatorsParsed = 0; position > separatorsParsed;
                   separatorsParsed++ )
             {
                 inx = item.indexOf( separator, inx ) + 1;
             }
      
             iny = item.indexOf( separator, inx );

             if ( iny == -1 ) // Last item
             {
                 iny = item.length();
             }
         

             return item.substring( inx, iny );
         }
         catch ( Exception e ) // Out of bounds
         {
         }

         return "";
     }


     static int findCommas( String item )
     {
         return findChar( item, ',' );
     }

     static String commaParser( String item, int position )
     {
         int commasParsed;
         int inx = 0;
         int iny = 0;

         /** Skip commas **/

         for ( commasParsed = 0; position > commasParsed; commasParsed++ )
         {
             inx = item.indexOf( ',', inx ) + 1;
         }

         iny = item.indexOf( ',', inx );

         if ( iny == -1 ) // Last item
         {
             iny = item.length();
         }

         return item.substring( inx, iny );
     }

     static String getStuffBetween( String source, String start,
                                    String end )
     {
         String retval = "";
         int startPos  = 0;
         int endPos    = 0;

         try
         {
             startPos = source.indexOf( start ) + start.length();

             if ( startPos >= 0 )
             {
                 endPos = source.indexOf( end, startPos );

                 if ( endPos < 0 )
                 {
                     endPos = source.length();
                 }

                 retval = source.substring( startPos, endPos );
             }
         }
         catch ( Exception e ) // Something bad happened...bad string
         {
             retval = "";
         }

         return retval;
     }

     static String replaceAll( String source, String replace, String with )
     {
         boolean working = true;
         String  newString;
         int replacePos;
         int startPos = 0;

         while ( working )
         {
             replacePos = source.indexOf( replace, startPos );
             working = false;

             if ( replacePos >= 0 )
             {
                 newString = source.substring( 0, replacePos ) +
                             with +
                             source.substring( replacePos +
                                 replace.length(), source.length() );
                 source = newString;
                 startPos = replacePos + with.length();
                 working = true;
             }
         }

         return source;
     }

     static int getHex( char hexDigit )
     {
         if ( ( hexDigit >= '0' ) && ( hexDigit <= '9' ) )
         {
             return hexDigit - '0';
         }
         else if ( ( hexDigit >= 'a' ) && ( hexDigit <= 'f' ) )
         {
             return hexDigit - 'a' + 0x0a;
         }
         else if ( ( hexDigit >= 'A' ) && ( hexDigit <= 'F' ) )
         {
             return hexDigit - 'A' + 0x0a;
         }

         return 0;
     }

     static String urlEncoder( String body )
     {
         return URLEncoder.encode( body );
     }

     static String urlDecoder( String body )
     {
         StringBuffer newString = new StringBuffer();
         char firstDigit;
         char secondDigit;
         int value;
         int inx;
         char newChar;

         for ( inx = 0; inx < body.length(); inx++ )
         {
             if ( body.charAt( inx ) == '+' )
             {
                 newString.append( ' ' );
             }
             else if ( body.charAt( inx ) == '%' )
             {
                 inx++; // Skip %
                 firstDigit  = '0';
                 secondDigit = '0';

                 if ( ( inx + 1 ) < body.length() )
                 {
                     firstDigit = body.charAt( inx );
                     inx++;
                 }

                 if ( ( inx + 1 ) < body.length() )
                 {
                     secondDigit = body.charAt( inx );
                 }

                 value = getHex( firstDigit ) * 0x10 +
                         getHex( secondDigit );
                 newChar = (char) value;
                 newString.append( newChar );

                 //newString.append( "("+firstDigit+" "+getHex( firstDigit )
                 //         +secondDigit+getHex( secondDigit)+" "+value+" "+newChar+")" );
             }
             else
             {
                 newString.append( body.charAt( inx ) );
             }
         }

         return newString.toString();
     }

     static int getIntegerValue( String value )
     {
         int num = 0;

         try
         {
             num = new Integer( value ).intValue();
         }
         catch( Exception e ) // not an integer
         {
         }

         return num;
     }
}

