import java.net.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;

/**
 Server Administration
 **/

public class WWWAdmin
{
    static final String extName            = "extension";
    static final String parmName           = "parameter";
    static final String userName           = "user";
    static final String passName           = "password";
    static final String deleteAction       = "delete";
    static final String loginAction        = "login";
    static final String addUserAction      = "adduser";
    static final String addExtensionAction = "addextension";


    /**
     Main runServer function.  This is called from the Server class
     **/

   /*
    public WWWAdmin()
    {
    }*/

    static public void handleAdmin( WWWServer www,
                                    String requestedPage,
                                    PrintWriter to,
                                    OutputStream toBin,
                                    String adminHome )
    {
        int inx;
        dixie log = www.log;

        String page = StringTools.charParser( '/', requestedPage, 2 );
        String user = StringTools.charParser( '/', requestedPage, 3 );
        String pass = StringTools.charParser( '/', requestedPage, 4 );
        String data = StringTools.charParser( '/', requestedPage, 5 );

        if ( page.equals( loginAction ) )
        {
            data = user;
            user = StringTools.getStuffBetween( data, userName+"=", "&" );
            pass = StringTools.getStuffBetween( data, passName+"=", "&" );
        }

        String userURL = "/"+user+"/"+pass+"/";

        if ( log.validUser( user, pass ) )
        {
            www.sendFile( toBin, www.standardHeader );

            if ( page.equals( deleteAction ) )
            {
                log.deleteUser( data );
            }
            else if ( page.equals( addUserAction ) )
            {
                String newUser =
                    StringTools.getStuffBetween( data, userName+"=", "&" );
                String newPass =
                    StringTools.getStuffBetween( data, passName+"=", "&" );
                log.changePassword( newUser, newPass );
            }
            else if ( page.equals( addExtensionAction ) )
            {
                User newuser = new User();

                newuser.userName =
                    StringTools.getStuffBetween( data, userName+"=", "&" );
                newuser.extension =
                    StringTools.getStuffBetween( data, extName+"=", "&" );
                newuser.parameter =
                    StringTools.getStuffBetween( data, parmName+"=", "&" );
                newuser.password = User.invalidPassword;

                log.addUser( newuser );
            }

            www.sendAndDebug( to, "<TABLE CELLSPACING=0 BORDER CELLPADDING=0 "+
                              "WIDTH=\"100%\"><TR>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\"><B>Type</B></TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\"><B>Name</B></TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\"><B>Extension</B></TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\"><B>Parameter</B></TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\"><B>Options</B></TD></TR>" );

            for (Enumeration en = log.dixieProps.keys() ;
                 en.hasMoreElements() ;)
            {
                String key = (String)en.nextElement();
                String val = (String)log.dixieProps.get(key);

                if ( key.startsWith( log.usersHeader ) &&
                     key.endsWith( log.passwordTrailer ) )
                {
                    String userName = key.substring( log.usersHeader.length(),
                          key.length()-log.passwordTrailer.length() );
                    User info = log.getUser( userName );

                    if ( info.password.equals( User.invalidPassword ) )
                    {
                        www.sendAndDebug( to, 
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\">Extension</TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\">"+userName+"</TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\">"+info.extension+"</TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\">"+info.parameter+"</TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\">"+
                              "<a href=\"" +adminHome+"/"+
                                      deleteAction+userURL+
                                      userName+ "\">Delete</a></TD></TR>" );
                    }
                    else
                    {
                        www.sendAndDebug( to, 
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\">User</TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\">"+userName+"</TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\">-</TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\">-</TD>"+
                              "<TD WIDTH=\"20%\" VALIGN=\"TOP\">"+
                              "<a href=\"" +adminHome+"/"+
                                      deleteAction+userURL+
                                      userName+ "\">Delete</a></TD></TR>" );
                    }
                }
            }

            // End the table, show add forms

            www.sendAndDebug( to, "</TR></TABLE><br><hr>"+
                          "<TABLE CELLSPACING=0 BORDER=0 CELLPADDING=0 "+
                          "WIDTH=\"100%\"><TR>"+
                          "<TD WIDTH=\"50%\" VALIGN=\"TOP\">"+
                          "<b>Add User</b><br><form name=\"query\" action=\""+adminHome +
                          "/"+addUserAction+userURL+"\" method=\"get\">" +
                          "<LABEL for=\""+userName+"\">User:</LABEL>"+
                          "<INPUT type=\"text\" name=\""+userName+"\"><br>"+
                          "<LABEL for=\""+passName+"\">Password:</LABEL>"+
                          "<INPUT type=\"text\" name=\""+passName+"\"><br>"+
                          "<INPUT type=\"submit\" value=\"Add User\">"+
                          "</form>"+
                          "</td><TD WIDTH=\"50%\" VALIGN=\"TOP\">"+
                          "<b>Add Extension</b><br><form name=\"query\" action=\""+adminHome +
                          "/"+addExtensionAction+userURL+"\" method=\"get\">" +
                          "<LABEL for=\""+userName+"\">User:</LABEL>"+
                          "<INPUT type=\"text\" name=\""+userName+"\"><br>"+
                          "<LABEL for=\""+extName+"\">Extension Name:</LABEL>"+
                          "<INPUT type=\"text\" name=\""+extName+"\"><br>"+
                          "<LABEL for=\""+parmName+"\">Parameter:</LABEL>"+
                          "<INPUT type=\"text\" name=\""+parmName+"\"><br>"+
                          "<INPUT type=\"submit\" value=\"Add Extension\">"+
                          "</td></table></form><br>" );

            // Show extensions and their help

            www.sendAndDebug( to, "<b>Available Extensions:</b><br>" );

            for ( inx = 0; inx < StringTools.findCommas(
                  log.getInfo( log.extensionHeader+log.extensionListProp ) ); inx++ )
            {
                String extensionName = StringTools.commaParser(
                     log.getInfo( log.extensionHeader+log.extensionListProp), inx );
                www.sendAndDebug( to, extensionName+" - "+
                     log.getInfo( log.extensionHeader+extensionName+"."+
                                  log.htmlHelp ) + "<br>" );
            }

            www.sendFile( toBin, www.standardEnding );
        }
        else if ( user.length() != 0 ) // Illegal user - go to main
        {
            www.sendFile( toBin, www.mainPage );
        }
        else // No user - Send login page
        {
            www.sendFile( toBin, www.loginPage );
            www.sendFile( toBin, www.standardEnding );
        }
    }
}


