import java.net.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;

/**
 Web Server
 **/

public class WWWMail
{
    static final String showAction      = "show";
    static final String createAction    = "create";
    static final String deleteAction    = "delete";
    static final String loginAction     = "login";
    static final String subjectName     = "subject";
    static final String bodyName        = "body";
    static final String sendAction      = "send";
    static final String passName        = "password";
    static final String userName        = "user";

    static public void handleMail( WWWServer www,
                                   String requestedPage,
                                   PrintWriter to,
                                   OutputStream toBin,
                                   String mailHome )
    {
        int     inx;
        dixie   log = www.log;
        String  tempLtrs = "";
        boolean lineBroken = false;
        boolean lineBrokenR = false;
        boolean lineBrokenN = false;
        String  userURL = "";

        Letters letters = Letters.getLetters();

        String page = StringTools.charParser( '/', requestedPage, 2 );
        String user = StringTools.charParser( '/', requestedPage, 3 );
        String pass = StringTools.charParser( '/', requestedPage, 4 );
        String data = StringTools.charParser( '/', requestedPage, 5 );
        int    num  = StringTools.getIntegerValue( data );

        if ( page.equals( loginAction ) )
        {
            data = user;
            user = StringTools.getStuffBetween( data, userName+"=", "&" );
            pass = StringTools.getStuffBetween( data, passName+"=", "&" );
        }

        userURL = "/"+user+"/"+pass+"/";

        if ( log.validUser( user, pass ) )
        {
            www.sendFile( toBin, www.standardHeader );

            if ( page.equals( sendAction ) )
            {
                String fullUser = user;
                if ( user.indexOf( '@' ) == -1 ) // No xx@yy type address
                {
                    fullUser = user+"@"+www.getHostName();
                }

                processLetter( www, to, data, fullUser );
                www.sendAndDebug( to, "Message sent!" );
            }
            else if ( page.equals( createAction ) )
            {
                www.sendAndDebug( to, "<form name=\"query\" action=\"/mail/"+sendAction+userURL+
                                  "\" method=\"get\">" );
                www.sendAndDebug( to, "<LABEL for=\"to\">To:</LABEL>"+
                                  "<INPUT type=\"text\" name=\"to\"><br>"+
                                  "<LABEL for=\""+subjectName+"\">Subject:</LABEL>"+
                                  "<INPUT type=\"text\" name=\""+subjectName+"\"><br>"+
                                  "<LABEL for=\""+bodyName+"\">Message:</LABEL>"+
                                  "<textarea rows=\"20\" cols=\"70\" name =\""+bodyName+"\"></textarea><br>"+
                                  "<INPUT type=\"submit\" value=\"Send\">"+
                                  "</form>" );
            }
            else if ( page.equals( deleteAction ) )
            {
                Letters tempLtr = Letters.locateLetter( user, num );

                if ( tempLtrs != null )
                {
                    tempLtr.markDelete();
                    tempLtr.delete( user );
                }

                num = 0;
            }

            if ( !page.equals( createAction ) )
            {
                www.sendAndDebug( to, "<a href=\"/mail/"+createAction+userURL+"\">Create and send Letter</a><br>");
            }

            www.sendAndDebug( to, "<a href=\"/mail/"+showAction+userURL+"\">Main Menu</a><br>");

            if ( ( page.equals( showAction ) )  ||
                 ( page.equals( sendAction ) )  ||
                 ( page.equals( loginAction ) ) ||
                 ( page.equals( deleteAction ) ) )
            {
                if ( num == 0 )
                {
                    www.sendAndDebug( to, "You have: " +
                                  letters.number( user ) +
                                  " letters.<br><hr>" );
                    showSubjects( letters, www, to, user, userURL );
                }
                else // Display the letter
                {
                    www.sendAndDebug( to, "<hr>" );
                    tempLtrs = Letters.locateLetter( user, num ).getBody( true );
                    StringBuffer buf = new StringBuffer();

                    for ( inx = 0; inx < tempLtrs.length(); inx++ )
                    {                                 
                        if ( tempLtrs.charAt( inx ) == '\n' ) 
                        {
                            buf.append( "<br>" );
                        }
                        else
                        {
                            buf.append( tempLtrs.charAt( inx ) );
                            lineBroken = false;
                        }
                    }

                    www.sendAndDebug( to, buf.toString()+
                                  "<br><hr><a href=\"/mail/"+deleteAction+
                                  userURL+num+"\">Delete this letter</a>" );
                }
            } // If showAction

            www.sendFile( toBin, www.standardEnding );
        }
        else if ( user.length() != 0 ) // Illegal user - go to main
        {
            www.sendFile( toBin, www.mainPage );
        }
        else // No user - Send login page
        {
            www.sendFile( toBin, www.loginPage );
            www.sendFile( toBin, www.standardEnding );
        }
    }

    static void processLetter( WWWServer www, PrintWriter to, String data, String from )
    {
        String recipient = StringTools.getStuffBetween( data, "to=", "&" );
        String body = StringTools.getStuffBetween( data, bodyName+"=", "&" );
        String subject = StringTools.getStuffBetween( data, subjectName+"=", "&" );
        body = StringTools.urlDecoder( body );
        subject = StringTools.urlDecoder( subject );
        new smtp( www.getHostName(), recipient, from,
                  "To: "+recipient+www.cr+
                  "From: "+from+www.cr+
                  "Subject: "+subject+
                  www.cr+www.cr+body );
    }

    static void showSubjects( Letters letters, WWWServer www,
                              PrintWriter to, String user, String userURL )
    {
        int inx;
        int ltr;

        for ( inx = 0; inx < letters.number( user ); inx++ )
        {
            ltr = inx + 1;
            www.sendAndDebug( to, "<a href=\"/mail/"+showAction+userURL+ltr+
                              "\">Letter "+ltr+" " );
            www.sendAndDebug( to, ":  "+
                Letters.locateLetter( user,ltr ).findLineStartingWith(
                "Subject" ) );

            www.sendAndDebug( to, "</a>" );

            if ( inx < letters.number( user ) - 1 )
            {
                www.sendAndDebug( to, "<br>" );
            }
        }
    }
}


