import java.net.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;

/**
 Web Server
 **/

public class WWWServer extends Server
{
    static final String serverType      = "DixieMail";
    static final String zipFileName     = "data.zip";
    static final String thisHost        = "127.0.0.1";
    static final String mainPage        = "/index.html";
    static final String loginPage       = "/login.html";
    static final String standardHeader  = "/stdhdr.html";
    static final String standardEnding  = "/stdend.html";
    static final String mailHome        = "/mail";
    static final String adminHome       = "/admin";
    static final String statusHome      = "/status";

    public String getHostName()
    {
        String temp;

        try
        {
            temp = InetAddress.getLocalHost().getHostName();
        }
        catch ( java.net.UnknownHostException y )
        {
            temp = thisHost;
        }

        return temp;
    }

    void transmit( OutputStream to, String data ) throws java.io.IOException
    {
        to.write( data.getBytes(), 0, data.length() );
    }


    void zipLocateFile( ZipInputStream zip, String fileName )
    throws FileNotFoundException
    {
        ZipEntry entry;

        try
        {
            entry = zip.getNextEntry();

            while ( fileName.toLowerCase().compareTo(
                    "/"+entry.getName().toLowerCase() ) != 0 )
            {
                zip.closeEntry();
                entry = zip.getNextEntry();
            }
        }
        catch ( Exception e )
        {
            throw new FileNotFoundException();
        }
    }

    void sendHeader( OutputStream to ) throws java.io.IOException
    {
        transmit( to, "HTTP/1.0 200 OK\n" );
        transmit( to, "Server: "+serverType+"\n");
        transmit( to, "\n");
    }


    void sendZipFile( OutputStream to, String fileName )
    throws FileNotFoundException
     {
         int size;
         byte cbuf[];
         byte read;
         ZipInputStream zip;
         int inx;
         int ms = 8000;
         File zipFile;
         FileInputStream fis;
         int bytesRead;
         int totalBytes = 0;

         /** Transmit file **/

         zipFile = new File( zipFileName );
         fis = new FileInputStream( zipFile );
         zip = new ZipInputStream( fis );

         try
         {
             zipLocateFile( zip, fileName );
             cbuf = new byte[ ms ];

             do
             {
                 bytesRead = zip.read( cbuf, 0, ms );

                 if ( bytesRead != -1 )
                 {                
                     to.write( cbuf, 0, ms );

                     //bytesSent += ms;
                     totalBytes += bytesRead;
                 }
             }
             while ( bytesRead != -1 );

             fis.close();
             zip.closeEntry();
             zip.close();
         }
         catch ( Exception e )
         {
            throw new FileNotFoundException();
         }
      }

    void sendFile( OutputStream toBin, String requestedPage )
    {
        try
        {
            sendZipFile( toBin, requestedPage );
        }
        catch ( Exception e )
        {
            try
            {
                sendZipFile( toBin, mainPage );
            }
            catch ( FileNotFoundException notFound )
            {
            }
        }
    }


    /**
     Main runServer function.  This is called from the Server class
     **/

    public void runServer( Socket localSocket )
        throws java.io.IOException, java.net.SocketException
    {
        BufferedReader from;
        PrintWriter to;
        String httpText;
        String command;
        String argument;
        OutputStream toBin; // Local outputstream
        String requestedPage = "";

        from  = new BufferedReader( new InputStreamReader( localSocket.getInputStream() ) );
        to    = new PrintWriter( new OutputStreamWriter( localSocket.getOutputStream() ), true );
        toBin = localSocket.getOutputStream();

        localSocket.setSoTimeout( socketTimeout );

        if ( monitorConnect )
        {
            log.write( serverName+": "+ localSocket.getInetAddress().toString()+ " connected" );
        }

        do
        {
            httpText = from.readLine();

            if ( httpText.startsWith( "GET" ) )
            {
                requestedPage = StringTools.firstWord(
                                StringTools.notFirstWord( httpText ) );
            }

            if ( debug )
            {
                log.write( serverName+": " + httpText );
            }
        }
        while ( httpText.length() != 0 );

        log.write( serverName + ": "+ requestedPage );

        sendHeader( toBin );

        if ( requestedPage.startsWith(mailHome) )
        {
            WWWMail.handleMail( this, requestedPage, to, toBin, mailHome );
        }
        else if ( requestedPage.startsWith(adminHome) )
        {
            WWWAdmin.handleAdmin( this, requestedPage, to, toBin, adminHome );
        }
        else if ( requestedPage.startsWith(statusHome) )
        {
            WWWStatus.showStatus( this, requestedPage, to, toBin, statusHome );
        }
        else
        {
            sendFile( toBin, requestedPage );
        }
    }

    /**
     Instantiates a WWW server
     **/

    public WWWServer( dixie logx )
    {
        log        = logx;
        port       = 80;
        serverName = "WWW";

        startServer();
    }
}


