import java.net.*;
import java.io.*;
import java.util.*;
import java.util.zip.*;

/**
 Server Administration
 **/

public class WWWStatus
{
    static private final String valueName = "value";
    static private final String loginAction = "login";   
    static private final String userName    = "user";
    static private final String passName    = "password";
    static private final String setSMTP     = "setsmtp";
    static private final String setServed   = "setserved";
    static private final String showWindow  = "showwin";
    static private final String startSmtp   = "startSmtp";
    static private final String stopSmtp    = "stopSmtp";
    static private final String startPop3   = "startPop3";
    static private final String stopPop3    = "stopPop3";
    static private final String startPass   = "startPass";
    static private final String stopPass    = "stopPass";
    static private final String stopWWW     = "stopWWW";


    //***************************************************************
    // showStatus
    //
    //     Builds a window that shows the status of dixieMail
    //***************************************************************

    static public void showStatus( WWWServer www,
                                   String requestedPage,
                                   PrintWriter to,
                                   OutputStream toBin,
                                   String statusHome )
    {
        int inx = 0;
        dixie log = www.log;
 

        String page = StringTools.charParser( '/', requestedPage, 2 );
        String user = StringTools.charParser( '/', requestedPage, 3 );
        String pass = StringTools.charParser( '/', requestedPage, 4 );
        String data = StringTools.charParser( '/', requestedPage, 5 );

        if ( page.equals( loginAction ) )
        {
            data = user;
            user = StringTools.getStuffBetween( data, userName+"=", "&" );
            pass = StringTools.getStuffBetween( data, passName+"=", "&" );
        }

        String userURL = "/"+user+"/"+pass+"/";

        if ( log.validUser( user, pass ) )
        {
            if ( page.equals( setSMTP ) )
            {
                log.setOutgoingSMTP( StringTools.getStuffBetween( data, valueName+"=", "&" ) );
            }
            else if ( page.equals( setServed ) )
            {
                log.setServedDomains( StringTools.urlDecoder( 
                     StringTools.getStuffBetween( data, valueName+"=", "&" ) ) );
            }
            else if ( page.equals( showWindow ) )
            {
               log.showMainWindow( true );
            }
            else if ( page.equals( startSmtp ) )
            {
               log.setActive( log.DM_SMTP, true );
            }
            else if ( page.equals( startPop3 ) )
            {
               log.setActive( log.DM_POP3, true );
            }
            else if ( page.equals( startPass ) )
            {
               log.setActive( log.DM_PASS, true );
            }
            else if ( page.equals( stopSmtp ) )
            {
               log.setActive( log.DM_SMTP, false );
            }
            else if ( page.equals( stopPop3 ) )
            {
               log.setActive( log.DM_POP3, false );
            }
            else if ( page.equals( stopPass ) )
            {
               log.setActive( log.DM_PASS, false );
            }
            else if ( page.equals( stopWWW ) )
            {
               log.setActive( log.DM_WWW, false );
            }

            www.sendFile( toBin, www.standardHeader );
            www.sendAndDebug( to, "Version: "+log.getVersionString() + "<br>"+
                              "Author: "+log.getAuthorString() +"<br>"+
                              "Outgoing SMTP: "+log.configuration.OutgoingServer + "<br>" +
                              "SMTP Max Servers: "+log.mailTask.getMaxMailServers() + "<br>" +
                              "SMTP Served Domains: "+log.configuration.ServedDomains+"<br>" +
                              "DixieMail Homepage: <a href=\""+log.getHomepageString()+
                              "\">"+ log.getHomepageString()+"</a><br>" );

            try
            {
                InetAddress here = InetAddress.getLocalHost();
                www.sendAndDebug( to, "Location: "+ here.getHostAddress()+"<br>"+
                                  "Names:<ul><li>"+here.getHostName() +"</li>" );

                try
                {
                    while ( true ) // Parse whole array
                    {
                        www.sendAndDebug( to, "<li>"+
                            InetAddress.getAllByName( here.getHostAddress() )[inx++] +
                            "</li>");
                    }
                }
                catch ( java.lang.ArrayIndexOutOfBoundsException arrayex )
                { }

                www.sendAndDebug( to, "</ul>" );
            }
            catch ( java.net.UnknownHostException uh )
            {
                www.sendAndDebug( to, "Note: Could not get local host information<br>" );
            }

            www.sendAndDebug( to, "<form action=\""+statusHome +
                          "/"+setSMTP+userURL+"\" method=\"get\">" +
                          "<LABEL for=\""+userName+"\">Outgoing SMTP:</LABEL>"+
                          "<INPUT type=\"text\" name=\""+valueName+"\">"+
                          "<INPUT type=\"submit\" value=\"Set\">"+
                          "</form>" +
                          "<form action=\""+statusHome +
                          "/"+setServed+userURL+"\" method=\"get\">" +
                          "<LABEL for=\""+userName+"\">Served Domains (Separated by commas):</LABEL>"+
                          "<INPUT type=\"text\" name=\""+valueName+"\">"+
                          "<INPUT type=\"submit\" value=\"Set\">"+
                          "</form>" +
                          "<form action=\""+statusHome +
                          "/"+showWindow+userURL+"\" method=\"get\">" +
                          "<INPUT type=\"submit\" value=\"Show Server Window\">"+
                          "</form>" +

                              "<TABLE CELLSPACING=0 BORDER CELLPADDING=0 WIDTH=\"100%\"><TR>" +

                              "<TD WIDTH=\"33%\">"+
                              "SMTP Server Active: "+ log.getActive( log.DM_SMTP ) +"</td>"+
                              "<TD WIDTH=\"33%\">"+
                              "<form action=\""+statusHome +
                              "/"+stopSmtp+userURL+"\" method=\"get\">" +
                              "<INPUT type=\"submit\" value=\"Stop SMTP\"></form>"+
                              "</TD><TD WIDTH=\"33%\">"+
                              "<form action=\""+statusHome +
                              "/"+startSmtp+userURL+"\" method=\"get\">" +
                              "<INPUT type=\"submit\" value=\"Start SMTP\"></form>"+
                              "</td></tr><tr>" +

                              "<TD WIDTH=\"33%\">"+
                              "POP3 Server Active: "+ log.getActive( log.DM_POP3 ) +"</td>" +
                              "</TD><TD WIDTH=\"33%\">"+
                              "<form action=\""+statusHome +
                              "/"+stopPop3+userURL+"\" method=\"get\">" +
                              "<INPUT type=\"submit\" value=\"Stop POP3\"></form>"+
                              "</TD><TD WIDTH=\"33%\">"+
                              "<form action=\""+statusHome +
                              "/"+startPop3+userURL+"\" method=\"get\">" +
                              "<INPUT type=\"submit\" value=\"Start POP3\"></form>"+
                              "</td></tr><tr>" +

                              "<TD WIDTH=\"33%\">"+
                              "Pass Server Active: "+ log.getActive( log.DM_PASS ) +"</td>" +
                              "<TD WIDTH=\"33%\">"+
                              "<form action=\""+statusHome +
                              "/"+stopPass+userURL+"\" method=\"get\">" +
                              "<INPUT type=\"submit\" value=\"Stop Pass\"></form>"+
                              "</TD><TD WIDTH=\"33%\">"+
                              "<form action=\""+statusHome +
                              "/"+startPass+userURL+"\" method=\"get\">" +
                              "<INPUT type=\"submit\" value=\"Start Pass\"></form>"+
                              "</td></tr><tr>" +

                              "<TD WIDTH=\"33%\">"+
                              "WWW Server Active: "+ log.getActive( log.DM_WWW ) +"</td>" +
                              "</TD><TD WIDTH=\"33%\">"+
                              "<form action=\""+statusHome +
                              "/"+stopWWW+userURL+"\" method=\"get\">" +
                              "<INPUT type=\"submit\" value=\"Stop WWW\"></form>"+
                              "</td><TD WIDTH=\"33%\">Once stopped, WWW cannot be restarted "+
                              "via the web interface." +
                              "</TD></TABLE>"
                                  );

            www.sendFile( toBin, www.standardEnding );
        }
        else if ( user.length() != 0 ) // Illegal user - go to main
        {
            www.sendFile( toBin, www.mainPage );
        }
        else // No user - Send login page
        {
            www.sendFile( toBin, www.loginPage );
            www.sendFile( toBin, www.standardEnding );
        }
    }
}


