import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.lang.reflect.*;
import StringTools;

/**
 Simple class to start and control the mail (Smtp, Pop3, and Epass) servers.
 Comments:
 970915 Original code, lots of modifications
 971006 Added real top processing
 971027 More cleanup, focus on SMTP, forwarding
 98xxxx Made into windows driven stuff
 990110 Even more cleanup
 990326 Split into separate files
 20 Feb 2000 Made event states into anonymous classes
 02 Mar 2000 Added WWW Server
 12 Mar 2000 Removed most of the menu driven options
 **/


/**
 * Create a frame that can be closed; only used if run standalone.
 */

class dixie extends CFrame
{
    private MenuBar menu;
    private Letters letters;
    public  SmtpServer mailTask;
    private Pop3Server popTask;
    private EpassServer passTask;
    private WWWServer wwwTask;
    private FileWriter wout;
    private boolean debugDixie = true;
    private MainDialog f;
    private CheckboxMenuItem debugBox;
    private CheckboxMenuItem monitorBox;
    private CheckboxMenuItem showStatusBox;

    final private String dixiePropsString      = "DixieMail.cfg";
    final private String versionString         = "DixieMail v1.7";
    final private String authorString          = "James Ghofulpo";
    final private String homepageString        = "http://welcome.to/reality";
    final private String monitorProp           = "monitorString";
    final private String debugProp             = "debugString";
    final private String monitorConnectProp    = "monitorConnect";
    final private String clearLogProp          = "clearLog";
    final private String extensionsProp        = "extensions";
    final private String optionsProp           = "options";
    final private String showSplashScreenProp  = "showSplash";
    final private String hideMainWindowProp    = "hideMainWindow";
    final private String lastValue             = "none";
    final private String nullProperty          = "<none>";
    final private String generalHelpProp       = "generalHelp";
    final public String extensionListProp      = "extensionList";
    final public String languageHeader         = "language.";
    final public String usersHeader            = "users.";
    final public String extensionHeader        = "extension.";
    final public String passwordTrailer        = ".password";
    final private String extensionTrailer      = ".extension";
    final private String parameterTrailer      = ".parameter";
    final public String invalidExtension       = ".";
    final public String htmlHelp               = "htmlHelp";
    final private String outgoingName          = "dixiemail.outgoing";
    final private String servedDomainsName     = "dixiemail.served";
    final private String configFileDescription = "DixieMail Configuration";

    public Config configuration;
    public Properties dixieProps;

    public static final int DM_WWW  = 1;
    public static final int DM_SMTP = 2;
    public static final int DM_POP3 = 3;
    public static final int DM_PASS = 4;

    String getVersionString()
    {
        return versionString;
    }

    String getAuthorString()
    {
        return authorString;
    }

    String getHomepageString()
    {
        return homepageString;
    }

    String getNullProperty()
    {
        return nullProperty;
    }

    private String getString( String propname )
    {
        return dixieProps.getProperty( languageHeader+propname,
                                       languageHeader+propname );
    }


    String getInfo( String propname )
    {
        return dixieProps.getProperty( propname, propname );
    }

    public void setServedDomains( String value )
    {
        if ( value.length() == 0 )
        {
            value = nullProperty;
        }

        configuration.ServedDomains = value;
        dixieProps.put( servedDomainsName, value );
        saveProperties();
    }

    public void setOutgoingSMTP( String value )
    {
        if ( value.length() == 0 )
        {
            value = nullProperty;
        }

        configuration.OutgoingServer = value;
        dixieProps.put( outgoingName, value );
        saveProperties();
    }

    public void showMainWindow( boolean show )
    {
         this.setVisible( show );
    }

    void saveProperties()
    {
        StringTools.saveProps( dixieProps, dixiePropsString,
                               configFileDescription );
    }

    //***************************************************************
    // main
    //
    //     Main function - Instantiates new instance of Dixie
    //***************************************************************

    public static void main( String argv[] )
    {
        new dixie( "dixie.gif" );
    }

    //***************************************************************
    // getUser
    //
    //     Returns user information
    //***************************************************************

    public User getUser( String userName )
    {
        User info = new User();

        info.password  = dixieProps.getProperty( 
                             usersHeader+userName+passwordTrailer,
                             User.invalidPassword );                                        
        info.parameter = getInfo( usersHeader+userName+parameterTrailer );
        info.extension = getInfo( usersHeader+userName+extensionTrailer );
        info.userName  = userName;

        return info;
    }


    //***************************************************************
    // getPassword
    //
    //     Returns a users password
    //***************************************************************

    public String getPassword( String user )
    {
        User info;

        info = getUser( user );

        return dixieProps.getProperty( usersHeader+user+
             passwordTrailer, User.invalidPassword );
    }


    //***************************************************************
    // validUser
    //
    //     Checks if a user/password combination is valid
    //***************************************************************

    public boolean validUser( String user, String password )
    {
        if ( dixieProps.getProperty( usersHeader+user+
             passwordTrailer, User.invalidPassword ).equals( password ) )
        {
            return true;
        }

        return false;
    }

    //***************************************************************
    // deleteUser
    //
    //     Deletes a user
    //***************************************************************

    public void deleteUser( String user )
    {
        dixieProps.remove( usersHeader+user+extensionTrailer );
        dixieProps.remove( usersHeader+user+passwordTrailer );
        dixieProps.remove( usersHeader+user+parameterTrailer );
        saveProperties();
    }

    //***************************************************************
    // addUser
    //
    //     Changes/adds a user/password combination
    //***************************************************************

    public void addUser( User user )
    {
        deleteUser( user.userName );
        dixieProps.put( usersHeader+user.userName+passwordTrailer,
                        user.password );
        dixieProps.put( usersHeader+user.userName+extensionTrailer,
                        user.extension );
        dixieProps.put( usersHeader+user.userName+parameterTrailer,
                        user.parameter );
        saveProperties();
    }



    //***************************************************************
    // changePassword
    //
    //     Changes/adds a user/password combination
    //***************************************************************

    public void changePassword( String user, String password )
    {
        deleteUser( user );
        dixieProps.put( usersHeader+user+passwordTrailer, password );
        dixieProps.put( usersHeader+user+extensionTrailer, invalidExtension );
        dixieProps.put( usersHeader+user+parameterTrailer, invalidExtension );
        saveProperties();
    }

    //***************************************************************
    // dixie
    //
    //     Main function - Builds menus and anonymous classes for
    //     the actions that need to be performed in them
    //***************************************************************

    public dixie( String iconName )
    {
        Menu   subMenu;
        CheckboxMenuItem cbox;
        String tempProperty;
        String extension;
        int    inx;
        MenuItem temp;

        configuration = new Config();
        dixieProps    = StringTools.loadProps( dixiePropsString );

        setTitle( versionString );
        setIconImage( Toolkit.getDefaultToolkit().getImage( iconName ) );
        addWindowListener( this );

        // Create the menu bar

        menu = new MenuBar();

        // Monitor menu **********************************************

        subMenu = new Menu( getString( monitorProp ) );
        menu.add( subMenu );

        // Clear log

        temp = new MenuItem( getString( clearLogProp ) );
        temp.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent e )
            {
                f.clearLog();
            }
        } ); // End of clear log anonymous class
        subMenu.add( temp );

        // Debug checkbox

        debugBox = new CheckboxMenuItem( getString( debugProp ) );
        debugBox.addItemListener( new ItemListener()
        {
            public void itemStateChanged( ItemEvent e )
            {
                boolean state = debugBox.getState();
         
                mailTask.setDebug( state );
                popTask.setDebug( state );
                passTask.setDebug( state );
                write( getString( debugProp )+" = "+state );
            }
        } ); // End of debug check box anonymous class
        subMenu.add( debugBox );

        // Monitor connect check box

        monitorBox = new CheckboxMenuItem( getString( monitorConnectProp ) );
        monitorBox.addItemListener( new ItemListener()
        {   
            public void itemStateChanged( ItemEvent e )
            {
                boolean state = monitorBox.getState();

                mailTask.setMonitorConnect( state );
                popTask.setMonitorConnect( state );
                passTask.setMonitorConnect( state );
                write( getString( monitorConnectProp )+" = "+state );
            }
        } ); // End of monitor check box anonymous class
        subMenu.add( monitorBox );

        // Add Options Menu

        subMenu = new Menu( getString( optionsProp ) );

        // Show splash screen

        temp = new MenuItem( getString( showSplashScreenProp ) );
        temp.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent e )
            {
                new Splash();
            }
        } );
        subMenu.add( temp );

        // Display status

        temp = new MenuItem( getString( hideMainWindowProp ) );
        temp.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent e )
            {
                showMainWindow( false );
            }
        } );
        subMenu.add( temp );
        menu.add( subMenu );

        this.setMenuBar( menu );

        f = new MainDialog();

        new Splash();

        add( f );
        pack();
        center();
        show();

        Letters.load();

        try
        {
            wout = new FileWriter( "mail.log", false );
        }
        catch( java.io.IOException e )
        {
            write("Could not open log file");
        }

        f.append( versionString + " - " + authorString + " - " +
                  homepageString );

        /** Set user defined variables **/

        configuration.OutgoingServer = dixieProps.getProperty( outgoingName, nullProperty );
        configuration.ServedDomains  = dixieProps.getProperty( servedDomainsName, nullProperty );
        configuration.versionString  = versionString;
        configuration.homepageString = homepageString;

        /** Start the servers **/

        mailTask = new SmtpServer( this );
        popTask  = new Pop3Server( this );
        passTask = new EpassServer( this );
        wwwTask  = new WWWServer( this );
    }

    /**
     Writes data to the mail.log file
     **/

    public void write( String data )
    {
        if ( debugDixie )
        {
            f.append( (new Date()).toString() + " " + data );
        }

        try
        {
            wout.write( (new Date()).toString() + " " + data + "\n" );
            wout.flush();
        }
        catch( java.io.IOException e )
        {
            f.append( (new Date()).toString() +
                      " Could not write to log file" );
        }
    }

    public boolean getActive( int server )
    {
        boolean retval = false; // Anything else is stopped

        switch ( server )
        {
            case DM_WWW:
                retval = !wwwTask.stopped;
            break;

            case DM_SMTP:
                retval = !mailTask.stopped;
            break;

            case DM_POP3:
                retval = !popTask.stopped;
            break;

            case DM_PASS:
                retval = !passTask.stopped;
            break;
        }

        return retval;
    }

    public void setActive( int server, boolean active )
    {
        if ( active )
        {
            switch ( server )
            {
                case DM_WWW:
                    wwwTask.startServer();
                break;

                case DM_SMTP:
                    mailTask.startServer();
                break;

                case DM_POP3:
                    popTask.startServer();
                break;

                case DM_PASS:
                    passTask.startServer();
                break;
            }
        }
        else
        {
            switch ( server )
            {
                case DM_WWW:
                    wwwTask.stopServer();
                break;

                case DM_SMTP:
                    mailTask.stopServer();
                break;

                case DM_POP3:
                    popTask.stopServer();
                break;

                case DM_PASS:
                    passTask.stopServer();
                break;
            }
        }
    }

    /**
     Starts the Smtp, Pop3, WWW, and Password Servers.
     Note that servers generally start automatically when created, so
     the constructor should take care of this the first time.
     **/

    public void start()
    {
        mailTask.startServer();
        popTask.startServer();
        passTask.startServer();
        wwwTask.startServer();
    }

    /**
     Stops the Smtp, Pop3, and Password Servers
     **/

    public void stop()
    {
        write( "Stopping DixieMail Server..." );
        mailTask.stopServer();
        popTask.stopServer();
        passTask.stopServer();
        wwwTask.stopServer();

        while ( !mailTask.stopped ||
                !popTask.stopped ||
                !passTask.stopped ||
                !wwwTask.stopped )
        {
            try
            {
                Thread.sleep( 100 );
            }
            catch ( java.lang.InterruptedException e )
            {
            }
        }
    }

    public void windowClosing( WindowEvent e )
    {
        stop();
        this.setVisible( false );
        System.exit(0);
    }
}



